/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs.atm;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.PreferenceManager;
import org.broad.igv.gs.atm.FileParameter;
import org.broad.igv.gs.atm.GSDataFormat;
import org.broad.igv.gs.atm.SubToolDescriptor;
import org.broad.igv.gs.atm.WebToolDescriptor;
import org.broad.igv.util.HttpUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ATMUtils {
    public static List<WebToolDescriptor> getWebTools() throws IOException, JSONException {
        URL url = new URL(PreferenceManager.getInstance().get("GENOME_SPACE_ATM_SERVER") + "webtool/descriptor");
        String contents = HttpUtils.getInstance().getContentsAsJSON(url);
        JSONTokener tk = new JSONTokener(contents);
        JSONArray array = new JSONArray(tk);
        List<WebToolDescriptor> webTools = ATMUtils.parseWebtools(array);
        return webTools;
    }

    public static WebToolDescriptor getWebTool(String name) throws IOException, JSONException {
        name = name.replace(" ", "%20");
        URL url = new URL(PreferenceManager.getInstance().get("GENOME_SPACE_ATM_SERVER") + "webtool/" + name + "/descriptor");
        String contents = HttpUtils.getInstance().getContentsAsJSON(url);
        JSONTokener tk = new JSONTokener(contents);
        JSONObject obj = new JSONObject(tk);
        return ATMUtils.parseWebTool(obj);
    }

    private static List<WebToolDescriptor> parseWebtools(JSONArray webDescArray) throws JSONException {
        int count = webDescArray.length();
        ArrayList<WebToolDescriptor> webTools = new ArrayList<WebToolDescriptor>();
        for (int i = 0; i < count; ++i) {
            JSONObject obj = webDescArray.getJSONObject(i);
            WebToolDescriptor webToolDescriptor = ATMUtils.parseWebTool(obj);
            webTools.add(webToolDescriptor);
        }
        return webTools;
    }

    private static WebToolDescriptor parseWebTool(JSONObject obj) throws JSONException {
        String name = obj.getAsString("name");
        String id = obj.getAsString("internalId");
        String author = obj.getAsString("author");
        String description = obj.getAsString("description");
        String baseUrl = obj.getAsString("baseUrl");
        JSONArray fileParamArray = obj.getJSONArray("fileParameters");
        List<FileParameter> fileParams = ATMUtils.parseFileParameters(fileParamArray);
        return new WebToolDescriptor(name, id, author, description, baseUrl, fileParams);
    }

    private static List<SubToolDescriptor> parseSubtools(JSONArray subToolsArray) throws JSONException {
        ArrayList<SubToolDescriptor> subtoolDescriptors = new ArrayList<SubToolDescriptor>();
        if (subToolsArray.length() > 0) {
            int nTools = subToolsArray.length();
            for (int n = 0; n < nTools; ++n) {
                JSONObject stObj = subToolsArray.getJSONArray(n).getJSONObject(1);
                String stName = stObj.getAsString("name");
                String stId = stObj.getAsString("id");
                String stVersion = stObj.getAsString("version");
                String stAuthor = stObj.getAsString("author");
                String stDescription = stObj.getAsString("description");
                String stHelp = stObj.getAsString("help");
                String stUrlModifier = stObj.getAsString("urlModifier");
                JSONArray stFileParams = stObj.getJSONArray("fileParameters").getJSONArray(1);
                List<FileParameter> fileParams = ATMUtils.parseFileParameters(stFileParams);
                subtoolDescriptors.add(new SubToolDescriptor(stName, stId, stVersion, stAuthor, stDescription, stHelp, stUrlModifier, fileParams));
            }
        }
        return subtoolDescriptors;
    }

    private static List<FileParameter> parseFileParameters(JSONArray fileParamsArray) throws JSONException {
        ArrayList<FileParameter> fileParameters = new ArrayList<FileParameter>();
        if (fileParamsArray.length() > 0) {
            int nFileParams = fileParamsArray.length();
            for (int n = 0; n < nFileParams; ++n) {
                JSONObject fObj = fileParamsArray.getJSONObject(n);
                String fpName = fObj.getAsString("name");
                String parentInternalId = fObj.getAsString("parentInternalId");
                String fpRequired = fObj.getAsString("required");
                String fpCompositeFilename = fObj.getAsString("compositeFilename");
                String fpNameDelimiters = fObj.getAsString("nameDelimiters");
                JSONArray formats = fObj.getJSONArray("formats");
                ArrayList<GSDataFormat> dataFormats = new ArrayList<GSDataFormat>();
                if (formats.length() > 0) {
                    int nFormats = formats.length();
                    for (int f = 0; f < nFormats; ++f) {
                        JSONObject format = formats.getJSONObject(f);
                        String fName = format.getAsString("name");
                        String fDescription = format.getAsString("description");
                        String fUrl = format.getAsString("url");
                        String fExt = format.getAsString("fileExtension");
                        dataFormats.add(new GSDataFormat(fName, fExt, fUrl));
                    }
                }
                fileParameters.add(new FileParameter(fpName, fpRequired, fpCompositeFilename, fpNameDelimiters, dataFormats));
            }
        }
        return fileParameters;
    }

    public static String getWebtoolLaunchURL(WebToolDescriptor descriptor) throws IOException {
        return ATMUtils.getWebtoolLaunchURL(descriptor, null);
    }

    public static String getWebtoolLaunchURL(WebToolDescriptor descriptor, String file) throws IOException {
        String name = descriptor.getName().replace(" ", "%20");
        String url = PreferenceManager.getInstance().get("GENOME_SPACE_ATM_SERVER") + "webtool/" + name + "/launchurl";
        List<FileParameter> fileParameters = descriptor.getFileParameters();
        if (file != null && fileParameters != null && fileParameters.size() > 0) {
            FileParameter param = fileParameters.get(0);
            url = url + "?" + param.getName() + "=" + URLEncoder.encode(file);
        }
        return HttpUtils.getInstance().getContentsAsString(new URL(url));
    }
}

