/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.feature.tribble.REPMaskCodec;
import org.broad.igv.feature.tribble.UCSCGeneTableCodec;
import org.broad.igv.feature.tribble.VCFWrapperCodec;
import org.broad.igv.peaks.PeakCodec;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.util.BlockCompressedInputStream;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCF3Codec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;

public class CodecFactory {
    private static Logger log = Logger.getLogger(CodecFactory.class);

    public static FeatureCodec getCodec(String path, Genome genome) {
        int l;
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            l = fn.length() - 3;
            fn = fn.substring(0, l);
        }
        if (fn.endsWith(".txt")) {
            l = fn.length() - 4;
            fn = fn.substring(0, l);
        }
        if (fn.endsWith(".vcf4")) {
            return new VCFWrapperCodec(new VCFCodec(), genome);
        }
        if (fn.endsWith(".vcf")) {
            return new VCFWrapperCodec(CodecFactory.getVCFCodec(path), genome);
        }
        if (fn.endsWith(".bed")) {
            return new IGVBEDCodec(genome);
        }
        if (fn.contains("refflat")) {
            return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.REFFLAT, genome);
        }
        if (fn.contains("genepred") || fn.contains("ensgene") || fn.contains("refgene")) {
            return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.GENEPRED, genome);
        }
        if (fn.contains("ucscgene")) {
            return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.UCSCGENE, genome);
        }
        if (fn.endsWith(".rmask") || fn.endsWith(".repmask")) {
            return new REPMaskCodec(genome);
        }
        if (fn.endsWith(".gff3") || fn.endsWith(".gvf")) {
            return new GFFCodec(GFFCodec.Version.GFF3, genome);
        }
        if (fn.endsWith(".gff") || fn.endsWith(".gtf")) {
            return new GFFCodec(genome);
        }
        if (fn.endsWith(".psl") || fn.endsWith(".pslx")) {
            return new PSLCodec(genome);
        }
        if (fn.endsWith(".peak")) {
            return new PeakCodec(genome);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureCodec getVCFCodec(String path) {
        BufferedReader reader = null;
        try {
            String formatLine;
            reader = path.toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new BlockCompressedInputStream(ParsingUtils.openInputStream(path)))) : org.broad.igv.util.ParsingUtils.openBufferedReader(path);
            for (int lineCount = 0; (formatLine = reader.readLine()) != null && lineCount < 20; ++lineCount) {
                String[] tmp;
                if (!formatLine.toLowerCase().startsWith("##fileformat") || (tmp = formatLine.split("=")).length <= 1) continue;
                String version = tmp[1].toLowerCase();
                if (version.startsWith("vcfv3")) {
                    VCF3Codec vCF3Codec = new VCF3Codec();
                    return vCF3Codec;
                }
                VCFCodec vCFCodec = new VCFCodec();
                return vCFCodec;
            }
        }
        catch (IOException e) {
            log.error("Error checking VCF Version");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new VCFCodec();
    }
}

