/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.hic.data.ContactRecord;

public class Block {
    private int number;
    private Map<Point, ContactRecord> contactRecordMap;
    ContactRecord[] records;

    public Block(int number) {
        this.number = number;
        this.contactRecordMap = new HashMap<Point, ContactRecord>();
    }

    public Block(int number, ContactRecord[] records) {
        this.number = number;
        this.records = records;
    }

    public void incrementCount(int col, int row) {
        Point p = new Point(col, row);
        ContactRecord rec = this.contactRecordMap.get(p);
        if (rec == null) {
            rec = new ContactRecord(this.number, col, row, 1);
            this.contactRecordMap.put(p, rec);
        } else {
            rec.incrementCount();
        }
    }

    public void parsingComplete() {
    }

    public ContactRecord[] getContactRecords() {
        return this.records;
    }

    public Collection<ContactRecord> getContractRecordValues() {
        return this.contactRecordMap.values();
    }
}

