/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.ChromosomeImpl;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.FastaDirectorySequence;
import org.broad.igv.feature.genome.FastaIndexedSequence;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.SequenceHelper;
import org.broad.igv.ui.util.MessageUtils;

public class GenomeImpl
implements Genome {
    private static Logger log = Logger.getLogger(GenomeImpl.class);
    public static final int MAX_WHOLE_GENOME = 10000;
    private String id;
    private String displayName;
    private List<String> chromosomeNames;
    private LinkedHashMap<String, Chromosome> chromosomeMap;
    private long length = -1L;
    private Map<String, Long> cumulativeOffsets = new HashMap<String, Long>();
    private Map<String, String> chrAliasTable;
    SequenceHelper sequenceHelper;

    public GenomeImpl(String id, String displayName, String sequencePath, boolean fasta, String[] fastaFiles) throws IOException {
        this.id = id;
        this.displayName = displayName;
        this.chrAliasTable = new HashMap<String, String>();
        if (sequencePath == null) {
            this.sequenceHelper = null;
        } else if (!fasta) {
            this.sequenceHelper = new SequenceHelper(sequencePath);
        } else if (fastaFiles != null) {
            FastaDirectorySequence sequence = new FastaDirectorySequence(sequencePath, fastaFiles);
            this.sequenceHelper = new SequenceHelper(sequence);
            this.chromosomeNames = new ArrayList<String>();
            for (FastaIndexedSequence fastaSequence : sequence.getFastaSequences()) {
                this.chromosomeNames.addAll(fastaSequence.getChromosomeNames());
            }
            Collections.sort(this.chromosomeNames, new ChromosomeComparator());
            this.chromosomeMap = new LinkedHashMap();
            for (FastaIndexedSequence fastaSequence : sequence.getFastaSequences()) {
                this.chromosomeNames.addAll(fastaSequence.getChromosomeNames());
            }
            for (FastaIndexedSequence fastaSequence : sequence.getFastaSequences()) {
                for (String chr : fastaSequence.getChromosomeNames()) {
                    int length = fastaSequence.getChromosomeLength(chr);
                    this.chromosomeMap.put(chr, new ChromosomeImpl(chr, length));
                }
            }
            this.updateChromosomeAliases();
        } else {
            FastaIndexedSequence fastaSequence = new FastaIndexedSequence(sequencePath);
            this.sequenceHelper = new SequenceHelper(fastaSequence);
            this.chromosomeNames = new ArrayList<String>(fastaSequence.getChromosomeNames());
            this.chromosomeMap = new LinkedHashMap(this.chromosomeNames.size());
            for (String chr : this.chromosomeNames) {
                int length = fastaSequence.getChromosomeLength(chr);
                this.chromosomeMap.put(chr, new ChromosomeImpl(chr, length));
            }
            this.updateChromosomeAliases();
        }
    }

    @Override
    public String getChromosomeAlias(String str) {
        if (str == null) {
            return str;
        }
        if (this.chrAliasTable.containsKey(str)) {
            return this.chrAliasTable.get(str);
        }
        this.chrAliasTable.put(str, str);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserDefinedAliases() {
        File aliasFile = new File(DirectoryManager.getGenomeCacheDirectory(), this.id + "_alias.tab");
        if (aliasFile.exists()) {
            if (this.chrAliasTable == null) {
                this.chrAliasTable = new HashMap<String, String>();
            }
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(aliasFile));
                this.loadChrAliases(br);
            }
            catch (Exception e) {
                log.error("Error loading chr alias table", e);
                MessageUtils.showMessage("<html>Error loading chromosome alias table.  Aliases will not be avaliable<br>" + e.toString());
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void loadChrAliases(BufferedReader br) throws IOException {
        String nextLine = "";
        while ((nextLine = br.readLine()) != null) {
            String[] kv = nextLine.split("\t");
            if (kv.length <= 1) continue;
            this.chrAliasTable.put(kv[0], kv[1]);
        }
    }

    public void addChrAliases(Map<String, String> aliases) {
        this.chrAliasTable.putAll(aliases);
    }

    private void updateChromosomeAliases() {
        String alias;
        for (String name : this.chromosomeNames) {
            if (!name.startsWith("gi|")) continue;
            alias = GenomeImpl.getNCBIName(name);
            this.chrAliasTable.put(alias, name);
            Chromosome chromosome = this.chromosomeMap.get(name);
        }
        if (this.chromosomeNames.size() < 1000) {
            for (String name : this.chromosomeNames) {
                if (name.endsWith(".fa")) {
                    alias = name.substring(0, name.length() - 3);
                    this.chrAliasTable.put(alias, name);
                    continue;
                }
                if (name.toLowerCase().startsWith("chr")) {
                    this.chrAliasTable.put(name.substring(3), name);
                    this.chrAliasTable.put(name + ".fa", name);
                    continue;
                }
                this.chrAliasTable.put("chr" + name, name);
                this.chrAliasTable.put("chr" + name + ".fa", name);
            }
            if (this.id.startsWith("hg") || this.id.equalsIgnoreCase("1kg_ref")) {
                this.chrAliasTable.put("23", "chrX");
                this.chrAliasTable.put("24", "chrY");
                this.chrAliasTable.put("MT", "chrM");
            } else if (this.id.startsWith("mm")) {
                this.chrAliasTable.put("21", "chrX");
                this.chrAliasTable.put("22", "chrY");
                this.chrAliasTable.put("MT", "chrM");
            } else if (this.id.equals("b37")) {
                this.chrAliasTable.put("chrM", "MT");
                this.chrAliasTable.put("chrX", "23");
                this.chrAliasTable.put("chrY", "24");
            }
        }
    }

    public static String getNCBIName(String name) {
        String[] tokens = name.split("\\|");
        return tokens[tokens.length - 1];
    }

    @Override
    public String getHomeChromosome() {
        if (this.getChromosomeNames().size() == 1 || this.chromosomeNames.size() > 10000) {
            return this.getChromosomeNames().get(0);
        }
        return "All";
    }

    @Override
    public Chromosome getChromosome(String chrName) {
        return this.chromosomeMap.get(this.getChromosomeAlias(chrName));
    }

    @Override
    public List<String> getChromosomeNames() {
        return this.chromosomeNames;
    }

    @Override
    public Collection<Chromosome> getChromosomes() {
        return this.chromosomeMap.values();
    }

    @Override
    public long getLength() {
        if (this.length < 0L) {
            this.length = 0L;
            for (Chromosome chr : this.chromosomeMap.values()) {
                this.length += (long)chr.getLength();
            }
        }
        return this.length;
    }

    @Override
    public long getCumulativeOffset(String chr) {
        Long cumOffset = this.cumulativeOffsets.get(chr);
        if (cumOffset == null) {
            long offset = 0L;
            for (String c : this.getChromosomeNames()) {
                if (chr.equals(c)) break;
                offset += (long)this.getChromosome(c).getLength();
            }
            cumOffset = new Long(offset);
            this.cumulativeOffsets.put(chr, cumOffset);
        }
        return cumOffset;
    }

    @Override
    public int getGenomeCoordinate(String chr, int locationBP) {
        return (int)((this.getCumulativeOffset(chr) + (long)locationBP) / 1000L);
    }

    @Override
    public ChromosomeCoordinate getChromosomeCoordinate(int genomeKBP) {
        long cumOffset = 0L;
        for (String c : this.chromosomeNames) {
            int chrLen = this.getChromosome(c).getLength();
            if ((cumOffset + (long)chrLen) / 1000L > (long)genomeKBP) {
                int bp = (int)((long)(genomeKBP * 1000) - cumOffset);
                return new ChromosomeCoordinate(c, bp);
            }
            cumOffset += (long)chrLen;
        }
        String c = this.chromosomeNames.get(this.chromosomeNames.size() - 1);
        int bp = (int)((long)genomeKBP - cumOffset) * 1000;
        return new ChromosomeCoordinate(c, bp);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNextChrName(String chr) {
        List<String> chrList = this.getChromosomeNames();
        for (int i = 0; i < chrList.size() - 1; ++i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i + 1);
        }
        return null;
    }

    @Override
    public String getPrevChrName(String chr) {
        List<String> chrList = this.getChromosomeNames();
        for (int i = chrList.size() - 1; i > 0; --i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i - 1);
        }
        return null;
    }

    @Override
    public byte[] getSequence(String chr, int start, int end) {
        if (this.sequenceHelper == null) {
            return null;
        }
        Chromosome c = this.getChromosome(chr);
        if (c == null) {
            return null;
        }
        if ((end = Math.min(end, c.getLength())) <= start) {
            return null;
        }
        return this.sequenceHelper.getSequence(chr, start, end, c.getLength());
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public byte getReference(String chr, int pos) {
        return this.sequenceHelper.getBase(chr, pos);
    }

    public void setCytobands(LinkedHashMap<String, List<Cytoband>> chrCytoMap) {
        for (Map.Entry<String, List<Cytoband>> entry : chrCytoMap.entrySet()) {
            String chr = entry.getKey();
            List<Cytoband> cytobands = entry.getValue();
            Chromosome chromosome = this.chromosomeMap.get(chr);
            if (chromosome == null) continue;
            ((ChromosomeImpl)chromosome).setCytobands(cytobands);
        }
    }

    public void generateChromosomeMap(LinkedHashMap<String, List<Cytoband>> chrCytoMap, boolean chromosomesAreOrdered) {
        this.chromosomeMap = new LinkedHashMap();
        for (Map.Entry<String, List<Cytoband>> entry : chrCytoMap.entrySet()) {
            String chr = entry.getKey();
            List<Cytoband> cytobands = entry.getValue();
            int length = cytobands.get(cytobands.size() - 1).getEnd();
            ChromosomeImpl chromosome = new ChromosomeImpl(chr, length);
            this.chromosomeMap.put(chr, chromosome);
        }
        this.chromosomeNames = new LinkedList<String>(this.chromosomeMap.keySet());
        if (!chromosomesAreOrdered) {
            Collections.sort(this.chromosomeNames, new ChromosomeComparator());
        }
        this.updateChromosomeAliases();
    }

    public static class ChromosomeComparator
    implements Comparator<String> {
        @Override
        public int compare(String chr1, String chr2) {
            try {
                int idx2;
                if (chr1.equals("chrM") || chr1.equals("MT")) {
                    return 1;
                }
                if (chr2.equals("chrM") || chr2.equals("MT")) {
                    return -1;
                }
                int idx1 = this.findDigitIndex(chr1);
                if (idx1 == (idx2 = this.findDigitIndex(chr2))) {
                    String alpha2;
                    String alpha1 = idx1 == -1 ? chr1 : chr1.substring(0, idx1);
                    int alphaCmp = alpha1.compareTo(alpha2 = idx2 == -1 ? chr2 : chr2.substring(0, idx2));
                    if (alphaCmp != 0) {
                        return alphaCmp;
                    }
                    int dig1 = Integer.parseInt(chr1.substring(idx1));
                    int dig2 = Integer.parseInt(chr2.substring(idx2));
                    return dig1 - dig2;
                }
                if (idx1 == -1) {
                    return 1;
                }
                if (idx2 == -1) {
                    return -1;
                }
                return idx1 - idx2;
            }
            catch (Exception numberFormatException) {
                return 0;
            }
        }

        int findDigitIndex(String chr) {
            int n = chr.length() - 1;
            if (!Character.isDigit(chr.charAt(n))) {
                return -1;
            }
            for (int i = n - 1; i > 0; --i) {
                if (Character.isDigit(chr.charAt(i))) continue;
                return i + 1;
            }
            return 0;
        }
    }
}

