/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.goby;

import edu.cornell.med.icb.goby.alignments.AlignmentReaderImpl;
import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.goby.GobyAlignmentIterator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentReader;

public class GobyAlignmentQueryReader
implements AlignmentReader {
    private static final Logger LOG = Logger.getLogger(GobyAlignmentQueryReader.class);
    private AlignmentReaderImpl reader = null;
    private final String basename;
    private DoubleIndexedIdentifier targetIdentifiers;
    private boolean isIndexed;
    private List<String> targetSequenceNames;

    public GobyAlignmentQueryReader(String filename) throws IOException {
        this.basename = filename;
        this.reader = new AlignmentReaderImpl(filename);
        this.reader.readHeader();
        if (!this.reader.isIndexed()) {
            String errorMessage = "Goby alignment files must be sorted in order to be loaded in IGV. See the IGV tutorial at http://goby.campagnelab.org/ for details.";
            System.err.println("Goby alignment files must be sorted in order to be loaded in IGV. See the IGV tutorial at http://goby.campagnelab.org/ for details.");
            throw new UnsupportedOperationException("Goby alignment files must be sorted in order to be loaded in IGV. See the IGV tutorial at http://goby.campagnelab.org/ for details.");
        }
        IndexedIdentifier identifiers = this.reader.getTargetIdentifiers();
        identifiers.put(new MutableString("M"), identifiers.getInt(new MutableString("MT")));
        this.targetIdentifiers = new DoubleIndexedIdentifier(identifiers);
        this.isIndexed = this.reader.isIndexed();
        this.targetSequenceNames = new ArrayList<String>();
        for (MutableString ms : identifiers.keySet()) {
            this.targetSequenceNames.add(ms.toString());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return this.targetSequenceNames;
    }

    public SAMFileHeader getHeader() {
        return null;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return new GobyAlignmentIterator(this.getNewLocalReader(), this.targetIdentifiers);
    }

    @Override
    public final CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        LOG.debug(String.format("query %s %d %d %b%n", sequence, start, end, contained));
        MutableString id = new MutableString(sequence);
        int referenceIndex = this.targetIdentifiers.getIndex(id);
        if (referenceIndex == -1) {
            referenceIndex = this.targetIdentifiers.getIndex(id.replace("chr", ""));
        }
        try {
            return new GobyAlignmentIterator(this.getNewLocalReader(), this.targetIdentifiers, referenceIndex, sequence, start, end);
        }
        catch (IOException e) {
            LOG.error(e);
            return null;
        }
    }

    @Override
    public final boolean hasIndex() {
        return this.isIndexed;
    }

    public static boolean supportsFileType(String filename) {
        boolean result = AlignmentReaderImpl.canRead(filename);
        LOG.debug(String.format("supportsFileType %s result=%b", filename, result));
        return result;
    }

    private AlignmentReaderImpl getNewLocalReader() {
        if (this.reader != null) {
            return this.reader;
        }
        try {
            return new AlignmentReaderImpl(this.basename);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

