/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.Globals;
import org.broad.igv.hic.tools.AlignmentPair;
import org.broad.igv.hic.tools.PairIterator;
import org.broad.igv.util.ParsingUtils;

public class AsciiPairIterator
implements PairIterator {
    static Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private Map<String, Integer> chromosomeOrdinals;
    AlignmentPair nextPair = null;
    BufferedReader reader;
    Map<String, String> stringInternPool = new HashMap<String, String>();

    public AsciiPairIterator(String path, Map<String, Integer> chromosomeOrdinals) throws IOException {
        this.reader = ParsingUtils.openBufferedReader(path);
        this.chromosomeOrdinals = chromosomeOrdinals;
        this.advance();
    }

    private void advance() {
        try {
            String nextLine;
            while ((nextLine = this.reader.readLine()) != null) {
                String[] tokens = Globals.whitespacePattern.split(nextLine);
                int nTokens = tokens.length;
                if (nTokens >= 10) continue;
                String chrom1 = this.getInternedString(tokens[1]);
                String chrom2 = this.getInternedString(tokens[5]);
                if (!this.chromosomeOrdinals.containsKey(chrom1) || !this.chromosomeOrdinals.containsKey(chrom2)) continue;
                int chr1 = this.chromosomeOrdinals.get(chrom1);
                int chr2 = this.chromosomeOrdinals.get(chrom2);
                int pos1 = Integer.parseInt(tokens[2]);
                int pos2 = Integer.parseInt(tokens[6]);
                this.nextPair = new AlignmentPair(chr1, pos1, chr2, pos2);
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.nextPair = null;
    }

    private String getInternedString(String aString) {
        String s = this.stringInternPool.get(aString);
        if (s == null) {
            s = new String(aString);
            this.stringInternPool.put(aString, s);
        }
        return s;
    }

    @Override
    public boolean hasNext() {
        return this.nextPair != null;
    }

    @Override
    public AlignmentPair next() {
        AlignmentPair p = this.nextPair;
        this.advance();
        return p;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

