/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class BrowserLauncher {
    static Logger log = Logger.getLogger(BrowserLauncher.class);
    private static int jvm;
    private static final int WINDOWS = 1;
    private static final int MAC = 2;
    private static final int OTHER = 3;
    private static final int SPECIFIED = 4;
    private static String specifiedBrowser;

    private BrowserLauncher() {
    }

    public static void openURL(String url) throws IOException {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            BrowserLauncher.openURL_old(url);
        } else {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (URISyntaxException e) {
                log.error("Error opening url " + url, e);
            }
        }
    }

    private static void openURL_old(String url) throws IOException {
        switch (jvm) {
            case 2: {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", url});
                break;
            }
            case 1: {
                Process process = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            case 3: {
                if (new File("/usr/bin/gnome-open").exists()) {
                    Runtime.getRuntime().exec(new String[]{"/usr/bin/gnome-open", url});
                    break;
                }
                if (!new File("/usr/bin/kde-open").exists()) break;
                Runtime.getRuntime().exec(new String[]{"/usr/bin/kde-open", url});
                break;
            }
            case 4: {
                Process process = Runtime.getRuntime().exec(new String[]{specifiedBrowser, url});
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
        }
    }

    public static void setSpecifiedBrowser(String s) {
        specifiedBrowser = s;
        jvm = 4;
    }

    static {
        String osName = System.getProperty("os.name");
        jvm = osName.startsWith("Mac OS") ? 2 : (osName.startsWith("Windows") ? 1 : 3);
    }
}

