/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.broad.igv.ui.IGV;

public class UIUtilities {
    private static final StringBuffer scratchBuffer = new StringBuffer();

    public static Color showColorChooserDialog(String dialogTitle, Color defaultColor) {
        Color color = null;
        JColorChooser chooser = new JColorChooser();
        chooser.setColor(defaultColor);
        do {
            int response;
            if ((response = JOptionPane.showConfirmDialog(IGV.getMainFrame(), chooser, dialogTitle, 2)) != 2 && response != -1) continue;
            return null;
        } while ((color = chooser.getColor()) == null);
        return color;
    }

    public static boolean showConfirmationDialog(Component parent, String message) {
        int status = JOptionPane.showConfirmDialog(parent, message, null, 2, -1, null);
        return status != 2 && status != -1;
    }

    public static String getcommaSeparatedRGBString(Color color) {
        if (color != null) {
            scratchBuffer.delete(0, scratchBuffer.length());
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            scratchBuffer.append(red);
            scratchBuffer.append(",");
            scratchBuffer.append(green);
            scratchBuffer.append(",");
            scratchBuffer.append(blue);
        }
        return scratchBuffer.toString();
    }

    public static void centerWindow(Window window) {
        Dimension dimension = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - dimension.width) / 2;
        int y = (screenSize.height - dimension.height) / 2;
        window.setLocation(x, y);
        window.requestFocus();
    }

    public static void invokeOnEventThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

