/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.compression;

import edu.cornell.med.icb.goby.compression.ChunkCodec;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChunkCodecHelper {
    private static final Log LOG = LogFactory.getLog(ChunkCodecHelper.class);
    private static final ServiceLoader<ChunkCodec> codecLoader = ServiceLoader.load(ChunkCodec.class);

    private ChunkCodecHelper() {
    }

    public static synchronized ChunkCodec load(String codecName) {
        ChunkCodec codec = null;
        if (codecName != null) {
            codecLoader.reload();
            for (ChunkCodec c : codecLoader) {
                if (!c.name().equals(codecName)) continue;
                LOG.debug("Will use chunk codec " + c.name());
                codec = c;
                break;
            }
            if (codec == null) {
                LOG.info("Could not find codec " + codecName);
            }
        }
        return codec;
    }

    public static synchronized ChunkCodec withRegistrationCode(byte registrationCode) {
        codecLoader.reload();
        for (ChunkCodec chunkCodec : codecLoader) {
            if (chunkCodec.registrationCode() != registrationCode) continue;
            return chunkCodec;
        }
        throw new InternalError("Codec registration code not recognized: " + registrationCode);
    }
}

