/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import java.util.Map;
import org.broad.igv.hic.tools.DensityCalculation;

public class DensityFunction {
    private double[] density;
    private int nPoints;
    private Map<Integer, Double> normFactors;
    private double sum;

    public DensityFunction(int gridSize, double[] densities, Map<Integer, Double> normFactors) {
        this.density = densities;
        this.nPoints = densities.length;
        this.normFactors = normFactors;
        this.sum = 0.0;
        for (int i = 0; i < this.nPoints; ++i) {
            this.sum += this.density[i];
        }
    }

    public DensityFunction(DensityCalculation calculation) {
        this(calculation.getGridSize(), calculation.getDensityAvg(), calculation.getNormalizationFactors());
    }

    public double getSum() {
        return this.sum;
    }

    public double getDensity(int chrIdx, int distance) {
        double normFactor = 1.0;
        if (distance >= this.nPoints) {
            return this.density[this.nPoints - 1] / normFactor;
        }
        return this.density[distance] / normFactor;
    }
}

