/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.StringUtils;

public class CommandExecutor {
    private static Logger log = Logger.getLogger(CommandExecutor.class);
    private File snapshotDirectory;
    private IGV igv = IGV.getFirstInstance();
    private int sleepInterval = 2000;

    private List<String> getArgs(String[] tokens) {
        ArrayList<String> args = new ArrayList<String>(tokens.length);
        for (String s : tokens) {
            if (s.trim().length() <= 0) continue;
            args.add(s.trim());
        }
        return args;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(String command) {
        List<String> args = this.getArgs(StringUtils.breakQuotedString(command, ' ').toArray(new String[0]));
        String result = "OK";
        System.out.println();
        log.debug("Executing: " + command);
        try {
            String param4;
            if (args.size() <= 0) return "Empty command string";
            String cmd = args.get(0).toLowerCase();
            String param1 = args.size() > 1 ? args.get(1) : null;
            String param2 = args.size() > 2 ? args.get(2) : null;
            String param3 = args.size() > 3 ? args.get(3) : null;
            String string = param4 = args.size() > 4 ? args.get(4) : null;
            if (cmd.equals("echo")) {
                result = cmd;
            } else {
                if (cmd.equals("gotoimmediate")) {
                    return this.gotoImmediate(args);
                }
                if (cmd.equals("goto")) {
                    result = this.goto1(args);
                } else if (cmd.equals("snapshotdirectory")) {
                    result = this.setSnapshotDirectory(param1);
                } else if (cmd.equals("snapshot")) {
                    String filename = param1;
                    this.createSnapshot(filename);
                } else if ((cmd.equals("loadfile") || cmd.equals("load")) && param1 != null) {
                    result = this.load(param1, param2, param3);
                } else if (cmd.equals("genome") && args.size() > 1) {
                    result = this.genome(param1);
                } else if (cmd.equals("new") || cmd.equals("reset") || cmd.equals("clear")) {
                    this.igv.resetSession(null);
                } else if (cmd.equals("region")) {
                    this.defineRegion(param1, param2, param3);
                } else if (cmd.equals("sort")) {
                    this.sort(param1, param2, param3, param4);
                } else if (cmd.equals("group")) {
                    this.group(param1);
                } else if (cmd.equals("collapse")) {
                    String trackName = param1 == null ? null : param1.replace("\"", "").replace("'", "");
                    this.collapse(trackName);
                } else if (cmd.equals("expand")) {
                    String trackName = param1 == null ? null : param1.replace("\"", "").replace("'", "");
                    this.expand(trackName);
                } else if (cmd.equals("tweakdivider")) {
                    this.igv.tweakPanelDivider();
                } else {
                    if (cmd.equals("maxpanelheight") && param1 != null) {
                        return this.setMaxPanelHeight(param1);
                    }
                    if (cmd.equals("tofront")) {
                        return this.bringToFront();
                    }
                    if (cmd.equalsIgnoreCase("viewaspairs")) {
                        return this.setViewAsPairs(param1, param2);
                    }
                    if (cmd.equalsIgnoreCase("samplingwindowsize")) {
                        return this.setSamplingWindowSize(param1);
                    }
                    if (cmd.equalsIgnoreCase("maxdepth") || cmd.equalsIgnoreCase("samplingreadcount")) {
                        return this.setSamplingReadCount(param1);
                    }
                    if (cmd.equalsIgnoreCase("setSleepInterval")) {
                        return this.setSleepInterval(param1);
                    }
                    if (cmd.equals("exit")) {
                        System.exit(0);
                    } else {
                        log.error("UNKOWN COMMAND: " + command);
                        return "UNKOWN COMMAND: " + command;
                    }
                }
            }
            this.igv.doRefresh();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.5) {
                log.debug("Clearing caches");
                LRUCache.clearCaches();
            }
            log.debug("Finished execution: " + command + "  sleeping ....");
            if (this.sleepInterval > 0) {
                Thread.sleep(this.sleepInterval);
            }
            log.debug("Finished sleeping");
        }
        catch (Exception e) {
            log.error("Could not Parse Command", e);
            return "ERROR Could not Parse Command: " + e.toString();
        }
        log.info(result);
        return result;
    }

    private String setViewAsPairs(String vAPString, String trackName) {
        List<Track> tracks = this.igv.getAllTracks(false);
        boolean vAP = !"false".equalsIgnoreCase(vAPString);
        for (Track track : tracks) {
            if (!(track instanceof AlignmentTrack) || trackName != null && !trackName.equalsIgnoreCase(track.getName())) continue;
            AlignmentTrack atrack = (AlignmentTrack)track;
            atrack.setViewAsPairs(vAP);
        }
        return "OK";
    }

    private String setSamplingWindowSize(String windowSize) {
        try {
            Integer.parseInt(windowSize);
            PreferenceManager.getInstance().override("SAM.SAMPLING_WINDOW", String.valueOf(windowSize));
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR: SAMPLING WINDOW IS NOT A NUMBER: " + windowSize;
        }
    }

    private String setSamplingReadCount(String samplingReadCount) {
        try {
            Integer.parseInt(samplingReadCount);
            PreferenceManager.getInstance().override("SAM.MAX_LEVELS", String.valueOf(samplingReadCount));
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR: SAMPLING READ COUNT IS NOT A NUMBER: " + samplingReadCount;
        }
    }

    private String gotoImmediate(List<String> args) {
        return this.goto1(args);
    }

    private String setMaxPanelHeight(String param1) {
        try {
            Integer h = Integer.parseInt(param1.trim());
            SnapshotUtilities.setMaxPanelHeight(h);
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR - max panel height value ('" + param1 + ".) must be an integer number";
        }
    }

    private String setSleepInterval(String param1) {
        try {
            this.sleepInterval = Integer.parseInt(param1.trim());
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR - sleep interval value ('" + param1 + ".) must be an integer number";
        }
    }

    private String genome(String param1) {
        if (param1 == null) {
            return "ERROR missing genome parameter";
        }
        String genomeID = param1;
        this.igv.selectGenomeFromList(genomeID);
        String result = "OK";
        return result;
    }

    private String load(String fileList, String param2, String param3) throws IOException {
        String fileString = (fileList = URLDecoder.decode(fileList, "UTF-8")).replace("\"", "").replace("'", "");
        String file = fileString;
        boolean merge = !file.endsWith(".xml") && !file.endsWith(".php") && !file.endsWith(".php3");
        String name = null;
        for (String param : Arrays.asList(param2, param3)) {
            if (param != null && param.startsWith("name=")) {
                name = param.substring(5);
                continue;
            }
            if (param == null || !param.startsWith("merge=")) continue;
            String mergeString = param.substring(6);
            merge = mergeString.equalsIgnoreCase("true");
        }
        Object locus = null;
        return this.loadFiles(fileString, null, merge, name);
    }

    String loadFiles(String fileString, String locus, boolean merge, String name) throws IOException {
        return this.loadFiles(fileString, locus, merge, name, null);
    }

    String loadFiles(String fileString, String locus, boolean merge, String name, Map<String, String> params) throws IOException {
        log.debug("Run load files");
        String[] files = fileString.split(",");
        ArrayList<ResourceLocator> fileLocators = new ArrayList<ResourceLocator>();
        ArrayList<String> sessionPaths = new ArrayList<String>();
        if (!merge) {
            boolean unload;
            boolean bl = unload = !merge;
            unload = fileString.endsWith(".xml") || fileString.endsWith(".php") || fileString.endsWith(".php3") ? !merge : MessageUtils.confirm("Unload current session before loading new tracks?");
            if (unload) {
                this.igv.resetSession(null);
            }
        }
        HashSet<String> loadedFiles = new HashSet<String>();
        for (ResourceLocator rl : this.igv.getDataResourceLocators()) {
            loadedFiles.add(rl.getPath());
        }
        for (String f : files) {
            File file;
            if (loadedFiles.contains(f)) continue;
            if (f.endsWith(".xml") || f.endsWith(".php") || f.endsWith(".php3") || f.endsWith(".session")) {
                sessionPaths.add(f);
                continue;
            }
            ResourceLocator rl = new ResourceLocator(f);
            if (rl.isLocal() && !(file = new File(f)).exists()) {
                return "Error: " + f + " does not exist.";
            }
            if (name != null) {
                rl.setName(name);
            }
            if (params != null) {
                String trackLine = this.createTrackLine(params);
                rl.setTrackLine(trackLine);
            }
            fileLocators.add(rl);
        }
        for (String sessionPath : sessionPaths) {
            this.igv.restoreSessionSynchronous(sessionPath, locus, merge);
        }
        this.igv.loadTracks(fileLocators);
        if (locus != null && !locus.equals("null")) {
            this.igv.goToLocus(locus);
        }
        return "OK";
    }

    private String createTrackLine(Map<String, String> params) {
        return params.get("hgt.customText");
    }

    private String bringToFront() {
        Frame mainFrame = IGV.getMainFrame();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        return "OK";
    }

    private String setSnapshotDirectory(String param1) {
        String result;
        if (param1 == null) {
            return "ERROR: missing directory parameter";
        }
        File parentDir = new File(param1);
        if (parentDir.exists()) {
            this.snapshotDirectory = parentDir;
            result = "OK";
        } else {
            parentDir.mkdir();
            if (parentDir.exists()) {
                this.snapshotDirectory = parentDir;
                result = "OK";
            } else {
                result = "ERROR: directory: " + param1 + " does not exist";
            }
        }
        return result;
    }

    private String goto1(List<String> args) {
        if (args == null || args.size() < 2) {
            return "ERROR: missing locus parameter";
        }
        String locus = args.get(1);
        for (int i = 2; i < args.size(); ++i) {
            locus = locus + " " + args.get(i);
        }
        this.igv.goToLocus(locus);
        return "OK";
    }

    private void collapse(String trackName) {
        if (trackName == null) {
            this.igv.collapseTracks();
        } else {
            this.igv.collapseTrack(trackName);
        }
        this.igv.repaintDataPanels();
    }

    private void expand(String trackName) {
        if (trackName == null) {
            this.igv.expandTracks();
        } else {
            this.igv.expandTrack(trackName);
        }
        this.igv.repaintDataPanels();
    }

    private void defineRegion(String param1, String param2, String param3) {
        Locus locus;
        RegionOfInterest roi = null;
        if (param1 != null && param2 != null && param3 != null) {
            int start = Math.max(0, Integer.parseInt(param2) - 1);
            int end = Integer.parseInt(param3);
            roi = new RegionOfInterest(param1, start, end, "");
        }
        if (param1 != null && (locus = new Locus(param1)).isValid()) {
            int start = Math.max(0, locus.getStart() - 1);
            roi = new RegionOfInterest(locus.getChr(), start, locus.getEnd(), "");
        }
        if (roi != null) {
            this.igv.addRegionOfInterest(roi);
        }
    }

    private void sort(String sortArg, String locusString, String param3, String param4) {
        RegionScoreType regionSortOption = CommandExecutor.getRegionSortOption(sortArg);
        String tag = "";
        if (regionSortOption != null) {
            Locus locus;
            RegionOfInterest roi = null;
            if (locusString != null && (locus = new Locus(locusString)).isValid()) {
                int start = Math.max(0, locus.getStart() - 1);
                roi = new RegionOfInterest(locus.getChr(), start, locus.getEnd(), "");
            }
            this.igv.sortByRegionScore(roi, regionSortOption, FrameManager.getDefaultFrame());
        } else {
            Double location = null;
            if (param3 != null && param3.trim().length() > 0) {
                try {
                    location = new Double(param3.replace(",", ""));
                    tag = param4;
                }
                catch (NumberFormatException e) {
                    tag = param3;
                }
            } else if (locusString != null && locusString.trim().length() > 0) {
                try {
                    location = new Double(locusString.replace(",", ""));
                    tag = param4;
                }
                catch (NumberFormatException e) {
                    tag = param3;
                }
            }
            if (location == null) {
                this.igv.sortAlignmentTracks(CommandExecutor.getAlignmentSortOption(sortArg), tag);
            } else {
                this.igv.sortAlignmentTracks(CommandExecutor.getAlignmentSortOption(sortArg), location, tag);
            }
        }
        this.igv.repaintDataPanels();
    }

    private void group(String sortArg) {
        this.igv.groupAlignmentTracks(CommandExecutor.getAlignmentGroupOption(sortArg));
        this.igv.repaintDataPanels();
    }

    private void createSnapshot(String filename) {
        if (filename == null) {
            String locus = FrameManager.getDefaultFrame().getFormattedLocusString();
            filename = locus.replaceAll(":", "_").replace("-", "_") + ".png";
        }
        File file = this.snapshotDirectory == null ? new File(filename) : new File(this.snapshotDirectory, filename);
        System.out.println("Snapshot: " + file.getAbsolutePath());
        SnapshotUtilities.doSnapshotOffscreen(this.igv.getMainPanel(), file);
    }

    private static RegionScoreType getRegionSortOption(String str) {
        if (str == null) {
            return null;
        }
        String option = str.toUpperCase();
        try {
            return RegionScoreType.valueOf(option);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static AlignmentTrack.SortOption getAlignmentSortOption(String str) {
        String string = str = str == null ? "base" : str;
        if (str.equalsIgnoreCase("start") || str.equalsIgnoreCase("position")) {
            return AlignmentTrack.SortOption.START;
        }
        if (str.equalsIgnoreCase("strand")) {
            return AlignmentTrack.SortOption.STRAND;
        }
        if (str.equalsIgnoreCase("base")) {
            return AlignmentTrack.SortOption.NUCELOTIDE;
        }
        if (str.equalsIgnoreCase("quality")) {
            return AlignmentTrack.SortOption.QUALITY;
        }
        if (str.equalsIgnoreCase("sample")) {
            return AlignmentTrack.SortOption.SAMPLE;
        }
        if (str.equalsIgnoreCase("readGroup") || str.equalsIgnoreCase("read_group")) {
            return AlignmentTrack.SortOption.READ_GROUP;
        }
        if (str.equalsIgnoreCase("insertSize") || str.equalsIgnoreCase("insert_size")) {
            return AlignmentTrack.SortOption.INSERT_SIZE;
        }
        if (str.equalsIgnoreCase("firstOfPairStrand")) {
            return AlignmentTrack.SortOption.FIRST_OF_PAIR_STRAND;
        }
        if (str.equalsIgnoreCase("mateChr")) {
            return AlignmentTrack.SortOption.MATE_CHR;
        }
        return AlignmentTrack.SortOption.NUCELOTIDE;
    }

    private static AlignmentTrack.GroupOption getAlignmentGroupOption(String str) {
        if (str.equalsIgnoreCase("strand")) {
            return AlignmentTrack.GroupOption.STRAND;
        }
        if (str.equalsIgnoreCase("sample")) {
            return AlignmentTrack.GroupOption.SAMPLE;
        }
        if (str.equalsIgnoreCase("readGroup") || str.equalsIgnoreCase("read_group")) {
            return AlignmentTrack.GroupOption.READ_GROUP;
        }
        return AlignmentTrack.GroupOption.NONE;
    }
}

