/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.AbstractSAMHeaderRecord;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.TextTagCodec;
import net.sf.samtools.util.DateParser;
import net.sf.samtools.util.LineReader;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.StringUtil;

public class SAMTextHeaderCodec {
    private static final String HEADER_LINE_START = "@";
    private SAMFileHeader mFileHeader;
    private final TextTagCodec mTagCodec = new TextTagCodec();
    private String mCurrentLine;
    private LineReader mReader;
    private String mSource;
    private List<SAMSequenceRecord> sequences;
    private List<SAMReadGroupRecord> readGroups;
    private final StringBuilder textHeader = new StringBuilder();
    private SAMFileReader.ValidationStringency validationStringency = SAMFileReader.ValidationStringency.SILENT;
    private BufferedWriter writer;
    private static final String TAG_KEY_VALUE_SEPARATOR = ":";
    private static final String FIELD_SEPARATOR = "\t";
    public static final String COMMENT_PREFIX = "@" + HeaderRecordType.CO.name() + "\t";

    public SAMFileHeader decode(LineReader reader, String source) {
        this.mFileHeader = new SAMFileHeader();
        this.mReader = reader;
        this.mSource = source;
        this.sequences = new ArrayList<SAMSequenceRecord>();
        this.readGroups = new ArrayList<SAMReadGroupRecord>();
        block7: while (this.advanceLine() != null) {
            ParsedHeaderLine parsedHeaderLine = new ParsedHeaderLine(this.mCurrentLine);
            if (!parsedHeaderLine.isLineValid()) continue;
            switch (parsedHeaderLine.getHeaderRecordType()) {
                case HD: {
                    this.parseHDLine(parsedHeaderLine);
                    continue block7;
                }
                case PG: {
                    this.parsePGLine(parsedHeaderLine);
                    continue block7;
                }
                case RG: {
                    this.parseRGLine(parsedHeaderLine);
                    continue block7;
                }
                case SQ: {
                    this.parseSQLine(parsedHeaderLine);
                    continue block7;
                }
                case CO: {
                    this.mFileHeader.addComment(this.mCurrentLine);
                    continue block7;
                }
            }
            throw new IllegalStateException("Unrecognized header record type: " + (Object)((Object)parsedHeaderLine.getHeaderRecordType()));
        }
        this.mFileHeader.setSequenceDictionary(new SAMSequenceDictionary(this.sequences));
        this.mFileHeader.setReadGroups(this.readGroups);
        if (!this.mFileHeader.getValidationErrors().isEmpty() || this.textHeader.length() < 0x100000) {
            this.mFileHeader.setTextHeader(this.textHeader.toString());
        }
        SAMUtils.processValidationErrors(this.mFileHeader.getValidationErrors(), -1L, this.validationStringency);
        return this.mFileHeader;
    }

    private String advanceLine() {
        int nextChar = this.mReader.peek();
        if (nextChar != 64) {
            return null;
        }
        this.mCurrentLine = this.mReader.readLine();
        this.textHeader.append(this.mCurrentLine).append("\n");
        return this.mCurrentLine;
    }

    private void transferAttributes(AbstractSAMHeaderRecord record, Map<String, String> textAttributes) {
        for (Map.Entry<String, String> entry : textAttributes.entrySet()) {
            record.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    private void parsePGLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.PG.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        if (!parsedHeaderLine.requireTag("ID")) {
            return;
        }
        SAMProgramRecord programRecord = new SAMProgramRecord(parsedHeaderLine.removeValue("ID"));
        this.transferAttributes(programRecord, parsedHeaderLine.mKeyValuePairs);
        this.mFileHeader.addProgramRecord(programRecord);
    }

    private void parseRGLine(ParsedHeaderLine parsedHeaderLine) {
        String dateRunProduced;
        assert (HeaderRecordType.RG.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        if (!parsedHeaderLine.requireTag("ID")) {
            return;
        }
        parsedHeaderLine.requireTag("SM");
        SAMReadGroupRecord samReadGroupRecord = new SAMReadGroupRecord(parsedHeaderLine.removeValue("ID"));
        this.transferAttributes(samReadGroupRecord, parsedHeaderLine.mKeyValuePairs);
        String predictedMedianInsertSize = samReadGroupRecord.getAttribute("PI");
        if (predictedMedianInsertSize != null) {
            try {
                Integer.parseInt(predictedMedianInsertSize);
                samReadGroupRecord.setAttribute("PI", predictedMedianInsertSize);
            }
            catch (NumberFormatException e) {
                this.reportErrorParsingLine("PI is not numeric: " + predictedMedianInsertSize, SAMValidationError.Type.INVALID_PREDICTED_MEDIAN_INSERT_SIZE, e);
            }
        }
        if ((dateRunProduced = samReadGroupRecord.getAttribute("DT")) != null) {
            Object date;
            try {
                date = this.mTagCodec.decodeDate(dateRunProduced);
            }
            catch (DateParser.InvalidDateException e) {
                date = dateRunProduced;
                this.reportErrorParsingLine("DT tag value '" + dateRunProduced + "' is not parseable as a date", SAMValidationError.Type.INVALID_DATE_STRING, e);
            }
            samReadGroupRecord.setAttribute("DT", date.toString());
        }
        this.readGroups.add(samReadGroupRecord);
    }

    private void parseSQLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.SQ.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        if (!parsedHeaderLine.requireTag("SN") || !parsedHeaderLine.requireTag("LN")) {
            return;
        }
        String sequenceName = parsedHeaderLine.removeValue("SN");
        sequenceName = SAMSequenceRecord.truncateSequenceName(sequenceName);
        SAMSequenceRecord samSequenceRecord = new SAMSequenceRecord(sequenceName, Integer.parseInt(parsedHeaderLine.removeValue("LN")));
        this.transferAttributes(samSequenceRecord, parsedHeaderLine.mKeyValuePairs);
        this.sequences.add(samSequenceRecord);
    }

    private void parseHDLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.HD.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        if (!parsedHeaderLine.requireTag("VN")) {
            return;
        }
        this.transferAttributes(this.mFileHeader, parsedHeaderLine.mKeyValuePairs);
    }

    private void reportErrorParsingLine(String reason, SAMValidationError.Type type, Throwable nestedException) {
        reason = "Error parsing SAM header. " + reason + ". Line:\n" + this.mCurrentLine;
        if (this.validationStringency == SAMFileReader.ValidationStringency.STRICT) {
            String fileMessage = "";
            if (this.mSource != null) {
                fileMessage = "File " + this.mSource;
            }
            throw new SAMFormatException(reason + "; " + fileMessage + "; Line number " + this.mReader.getLineNumber(), nestedException);
        }
        SAMValidationError error = new SAMValidationError(type, reason, null, this.mReader.getLineNumber());
        error.setSource(this.mSource);
        this.mFileHeader.addValidationError(error);
    }

    public void encode(Writer writer, SAMFileHeader header) {
        this.mFileHeader = header;
        this.writer = new BufferedWriter(writer);
        this.writeHDLine();
        for (SAMSequenceRecord sequenceRecord : header.getSequenceDictionary().getSequences()) {
            this.writeSQLine(sequenceRecord);
        }
        for (SAMReadGroupRecord readGroup : header.getReadGroups()) {
            this.writeRGLine(readGroup);
        }
        for (SAMProgramRecord programRecord : header.getProgramRecords()) {
            this.writePGLine(programRecord);
        }
        for (String comment : header.getComments()) {
            this.println(comment);
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void println(String s) {
        try {
            this.writer.append(s);
            this.writer.append("\n");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void writePGLine(SAMProgramRecord programRecord) {
        if (programRecord == null) {
            return;
        }
        String[] fields = new String[2 + programRecord.getAttributes().size()];
        fields[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.PG);
        fields[1] = "ID:" + programRecord.getProgramGroupId();
        this.encodeTags(programRecord, fields, 2);
        this.println(StringUtil.join((String)FIELD_SEPARATOR, (String[])fields));
    }

    private void writeRGLine(SAMReadGroupRecord readGroup) {
        String[] fields = new String[2 + readGroup.getAttributes().size()];
        fields[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.RG);
        fields[1] = "ID:" + readGroup.getReadGroupId();
        this.encodeTags(readGroup, fields, 2);
        this.println(StringUtil.join((String)FIELD_SEPARATOR, (String[])fields));
    }

    private void writeHDLine() {
        SAMFileHeader newHeader = new SAMFileHeader();
        for (Map.Entry<String, String> entry : this.mFileHeader.getAttributes()) {
            if (entry.getKey().equals("VN")) continue;
            newHeader.setAttribute(entry.getKey(), entry.getValue());
        }
        String[] fields = new String[1 + newHeader.getAttributes().size()];
        fields[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.HD);
        this.encodeTags(newHeader, fields, 1);
        this.println(StringUtil.join((String)FIELD_SEPARATOR, (String[])fields));
    }

    private void writeSQLine(SAMSequenceRecord sequenceRecord) {
        int numAttributes = sequenceRecord.getAttributes() != null ? sequenceRecord.getAttributes().size() : 0;
        String[] fields = new String[3 + numAttributes];
        fields[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.SQ);
        fields[1] = "SN:" + sequenceRecord.getSequenceName();
        fields[2] = "LN:" + Integer.toString(sequenceRecord.getSequenceLength());
        this.encodeTags(sequenceRecord, fields, 3);
        this.println(StringUtil.join((String)FIELD_SEPARATOR, (String[])fields));
    }

    private void encodeTags(AbstractSAMHeaderRecord rec, String[] fields, int offset) {
        for (Map.Entry<String, String> entry : rec.getAttributes()) {
            fields[offset++] = this.mTagCodec.encodeUntypedTag(entry.getKey(), entry.getValue());
        }
    }

    public void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        if (validationStringency == null) {
            throw new IllegalArgumentException("null validationStringency not allowed");
        }
        this.validationStringency = validationStringency;
    }

    private class ParsedHeaderLine {
        private HeaderRecordType mHeaderRecordType;
        private final Map<String, String> mKeyValuePairs = new HashMap<String, String>();
        private boolean lineValid = false;

        ParsedHeaderLine(String line) {
            assert (line.startsWith(SAMTextHeaderCodec.HEADER_LINE_START));
            String[] fields = line.split(SAMTextHeaderCodec.FIELD_SEPARATOR);
            try {
                this.mHeaderRecordType = HeaderRecordType.valueOf(fields[0].substring(1));
            }
            catch (IllegalArgumentException e) {
                SAMTextHeaderCodec.this.reportErrorParsingLine("Unrecognized header record type", SAMValidationError.Type.UNRECOGNIZED_HEADER_TYPE, null);
                this.mHeaderRecordType = null;
                return;
            }
            if (this.mHeaderRecordType == HeaderRecordType.CO) {
                this.lineValid = true;
                return;
            }
            for (int i = 1; i < fields.length; ++i) {
                String[] keyAndValue = fields[i].split(SAMTextHeaderCodec.TAG_KEY_VALUE_SEPARATOR, 2);
                if (keyAndValue.length != 2) {
                    SAMTextHeaderCodec.this.reportErrorParsingLine("Problem parsing @" + (Object)((Object)this.mHeaderRecordType) + " key:value pair", SAMValidationError.Type.POORLY_FORMATTED_HEADER_TAG, null);
                    continue;
                }
                if (this.mKeyValuePairs.containsKey(keyAndValue[0]) && !this.mKeyValuePairs.get(keyAndValue[0]).equals(keyAndValue[1])) {
                    SAMTextHeaderCodec.this.reportErrorParsingLine("Problem parsing @" + (Object)((Object)this.mHeaderRecordType) + " key:value pair " + keyAndValue[0] + SAMTextHeaderCodec.TAG_KEY_VALUE_SEPARATOR + keyAndValue[1] + " clashes with " + keyAndValue[0] + SAMTextHeaderCodec.TAG_KEY_VALUE_SEPARATOR + this.mKeyValuePairs.get(keyAndValue[0]), SAMValidationError.Type.HEADER_TAG_MULTIPLY_DEFINED, null);
                    continue;
                }
                this.mKeyValuePairs.put(keyAndValue[0], keyAndValue[1]);
            }
            this.lineValid = true;
        }

        public boolean isLineValid() {
            return this.lineValid;
        }

        boolean requireTag(String tag) {
            if (!this.mKeyValuePairs.containsKey(tag)) {
                SAMTextHeaderCodec.this.reportErrorParsingLine(SAMTextHeaderCodec.HEADER_LINE_START + (Object)((Object)this.mHeaderRecordType) + " line missing " + tag + " tag", SAMValidationError.Type.HEADER_RECORD_MISSING_REQUIRED_TAG, null);
                return false;
            }
            return true;
        }

        public HeaderRecordType getHeaderRecordType() {
            return this.mHeaderRecordType;
        }

        boolean containsKey(String key) {
            return this.mKeyValuePairs.containsKey(key);
        }

        String getValue(String key) {
            return this.mKeyValuePairs.get(key);
        }

        String removeValue(String key) {
            String ret = this.mKeyValuePairs.get(key);
            this.mKeyValuePairs.remove(key);
            return ret;
        }
    }

    private static enum HeaderRecordType {
        HD,
        SQ,
        RG,
        PG,
        CO;

    }
}

