/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.broad.igv.feature.AminoAcid;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.Strand;

public class AminoAcidManager {
    static String filename = "codonTable.txt";
    static Map<String, AminoAcid> codonTable;

    public static AminoAcidSequence getAminoAcidSequence(byte[] seqBytes, int startPosition, Strand strand) {
        if (seqBytes == null) {
            return null;
        }
        String nucSequence = new String(seqBytes);
        List<AminoAcid> acids = AminoAcidManager.getAminoAcids(nucSequence, strand);
        int aminoStart = startPosition;
        return new AminoAcidSequence(strand, aminoStart, acids);
    }

    public static List<AminoAcid> getAminoAcids(String sequence, Strand direction) {
        if (codonTable == null) {
            AminoAcidManager.initTable();
        }
        int readLength = sequence.length() / 3;
        ArrayList<AminoAcid> acids = new ArrayList<AminoAcid>(readLength);
        for (int i = 0; i <= sequence.length() - 3; i += 3) {
            String codon = sequence.substring(i, i + 3).toUpperCase();
            if (direction == Strand.NEGATIVE) {
                codon = AminoAcidManager.getNucleotideComplement(codon);
            }
            AminoAcid aa = AminoAcidManager.getAminoAcid(codon);
            acids.add(aa);
        }
        return acids;
    }

    public static AminoAcid getAminoAcid(String codon) {
        AminoAcid aa = AminoAcid.NULL_AMINO_ACID;
        if (codonTable == null) {
            AminoAcidManager.initTable();
        }
        if (codonTable != null && codon != null && (aa = codonTable.get(codon)) == null) {
            aa = AminoAcid.NULL_AMINO_ACID;
        }
        return aa;
    }

    public static AminoAcid getAminoAcidByName(String name) {
        if (codonTable == null) {
            AminoAcidManager.initTable();
        }
        for (AminoAcid aa : codonTable.values()) {
            boolean found = aa.equalsByName(name);
            if (!found) continue;
            return aa;
        }
        return AminoAcid.NULL_AMINO_ACID;
    }

    public static String getNucleotideComplement(String sequence) {
        char[] complement = new char[sequence.length()];
        int jj = complement.length;
        block6: for (int ii = 0; ii < sequence.length(); ++ii) {
            char c = sequence.charAt(ii);
            --jj;
            switch (c) {
                case 'T': 
                case 't': {
                    complement[jj] = 65;
                    continue block6;
                }
                case 'A': 
                case 'a': {
                    complement[jj] = 84;
                    continue block6;
                }
                case 'C': 
                case 'c': {
                    complement[jj] = 71;
                    continue block6;
                }
                case 'G': 
                case 'g': {
                    complement[jj] = 67;
                    continue block6;
                }
                default: {
                    complement[jj] = c;
                }
            }
        }
        return new String(complement);
    }

    public static Set<String> getMappingSNPs(String codon, AminoAcid mutAA) {
        HashSet<String> mapSNPs = new HashSet<String>();
        Set<String> SNPs = AminoAcidManager.getAllSNPs(codon);
        for (String modCodon : SNPs) {
            if (!codonTable.get(modCodon).equalsByName(mutAA.getShortName())) continue;
            mapSNPs.add(modCodon);
        }
        return mapSNPs;
    }

    public static Set<String> getAllSNPs(String sequence) {
        HashSet<String> SNPs = new HashSet<String>();
        char[] bps = "ATGC".toCharArray();
        char[] orig = sequence.toCharArray();
        for (int loc = 0; loc < orig.length; ++loc) {
            char[] mod = (char[])orig.clone();
            for (char bp : bps) {
                if (bp == orig[loc]) continue;
                mod[loc] = bp;
                SNPs.add(new String(mod));
            }
        }
        return SNPs;
    }

    static synchronized void initTable() {
        if (codonTable == null) {
            try {
                InputStream is = AminoAcidManager.class.getResourceAsStream("/resources/" + filename);
                if (is == null) {
                    return;
                }
                codonTable = new HashMap<String, AminoAcid>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String nextLine = null;
                while ((nextLine = reader.readLine()) != null) {
                    String[] tokens = nextLine.split("\t");
                    if (tokens.length != 4) continue;
                    String codon = tokens[0].trim().toUpperCase();
                    String fullName = tokens[1].trim();
                    String shortName = tokens[2].trim();
                    char symbol = tokens[3].trim().charAt(0);
                    codonTable.put(codon, new AminoAcid(fullName, shortName, symbol));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(AminoAcidManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

