/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureReader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFtoBed {
    public static void main(String[] args) throws IOException {
        VCFtoBed.convert(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String vcfFile, String bedFile) throws IOException {
        FeatureReader basicReader = null;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(bedFile)));
            Genome genome = null;
            FeatureCodec codec = CodecFactory.getCodec(vcfFile, genome);
            boolean isVCF = codec.getClass().isAssignableFrom(VCFCodec.class);
            basicReader = AbstractFeatureReader.getFeatureReader(vcfFile, codec, true);
            CloseableTribbleIterator iter = basicReader.iterator();
            while (iter.hasNext()) {
                VariantContext vc = (VariantContext)iter.next();
                String chr = vc.getChr();
                if (!chr.startsWith("chr")) {
                    chr = "chr" + chr;
                }
                int start = vc.getStart() - 1;
                int end = vc.getEnd();
                String id = vc.getID();
                if (id == null) {
                    id = ".";
                }
                String af = vc.getAttributeAsString("AF", "");
                writer.println(chr + "\t" + start + "\t" + end + "\t" + id + "\t" + af);
            }
        }
        finally {
            if (basicReader != null) {
                basicReader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

