/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.TrackFilterPane;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;

public class FilterTracksMenuAction
extends MenuAction {
    IGV mainFrame;
    private JCheckBox showAllTracksFilterCheckBox = new JCheckBox();
    private JCheckBox matchAllCheckBox = new JCheckBox();
    private JCheckBox matchAnyCheckBox = new JCheckBox();
    private TrackFilterPane trackFilterPane;

    public FilterTracksMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doFilterTracks();
    }

    private void doFilterTracks() {
        boolean previousDisableFilterState = this.showAllTracksFilterCheckBox.isSelected();
        boolean previousMatchAllState = this.matchAllCheckBox.isSelected();
        List<String> uniqueAttributeKeys = AttributeManager.getInstance().getAttributeNames();
        if (uniqueAttributeKeys == null && (uniqueAttributeKeys == null || uniqueAttributeKeys.isEmpty())) {
            MessageUtils.showMessage("No attributes found to use in a filter");
            return;
        }
        if (this.trackFilterPane == null) {
            this.trackFilterPane = new TrackFilterPane(uniqueAttributeKeys, "Show tracks whose attribute", this.mainFrame.getSession().getFilter());
        } else {
            this.trackFilterPane.setItems(uniqueAttributeKeys);
            this.trackFilterPane.backup();
            TrackFilter filter = this.trackFilterPane.getFilter();
            if (filter == null || filter.isEmpty()) {
                this.trackFilterPane.more();
            }
        }
        this.trackFilterPane.clearTracks();
        this.trackFilterPane.addTracks(IGV.getInstance().getAllTracks(false));
        while (true) {
            FilterTracksMenuAction filterTracksMenuAction = this;
            Integer response = this.createFilterTrackDialog(filterTracksMenuAction.mainFrame.getMainFrame(), this.trackFilterPane, "Filter Tracks");
            if (response == null) continue;
            if (response == 2) {
                boolean matchAllState;
                boolean disableFilterState = this.showAllTracksFilterCheckBox.isSelected();
                if (disableFilterState != previousDisableFilterState) {
                    this.showAllTracksFilterCheckBox.setSelected(previousDisableFilterState);
                }
                if ((matchAllState = this.matchAllCheckBox.isSelected()) != previousMatchAllState) {
                    this.matchAllCheckBox.setSelected(previousMatchAllState);
                    this.matchAnyCheckBox.setSelected(!previousMatchAllState);
                }
                this.trackFilterPane.restore();
                return;
            }
            if (response == 0) break;
        }
        this.filterTracks(this.trackFilterPane);
        this.mainFrame.doRefresh();
    }

    private Integer createFilterTrackDialog(Frame parent, final TrackFilterPane trackFilterPane, String title) {
        Component[] children;
        JScrollPane scrollPane = new JScrollPane(trackFilterPane);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        int optionType = 2;
        int messageType = -1;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel filterHeaderPanel = new JPanel();
        filterHeaderPanel.setBackground(Color.WHITE);
        filterHeaderPanel.setLayout(new GridLayout(0, 1));
        filterHeaderPanel.add(new JLabel("For attributes that:"));
        ButtonGroup booleanButtonGroup = new ButtonGroup();
        booleanButtonGroup.add(this.matchAllCheckBox);
        booleanButtonGroup.add(this.matchAnyCheckBox);
        this.showAllTracksFilterCheckBox.setText("Show All Tracks");
        this.matchAllCheckBox.setText("Match all of the following");
        this.matchAnyCheckBox.setText("Match any of the following");
        boolean matchAll = trackFilterPane.getMatchAll();
        if (matchAll) {
            this.matchAllCheckBox.setSelected(true);
        } else {
            this.matchAnyCheckBox.setSelected(true);
        }
        this.matchAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                trackFilterPane.setMatchAll(true);
            }
        });
        this.matchAnyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                trackFilterPane.setMatchAll(false);
            }
        });
        JPanel controls = new JPanel();
        FlowLayout layoutManager = new FlowLayout();
        layoutManager.setAlignment(0);
        controls.setLayout(layoutManager);
        controls.add(this.matchAllCheckBox);
        controls.add(this.matchAnyCheckBox);
        controls.add(this.showAllTracksFilterCheckBox);
        controls.setBackground(Color.WHITE);
        controls.setOpaque(true);
        filterHeaderPanel.add(controls);
        panel.setOpaque(true);
        panel.add((Component)filterHeaderPanel, "North");
        panel.add((Component)scrollPane, "Center");
        JOptionPane optionPane = new JOptionPane(panel, messageType, optionType);
        optionPane.setPreferredSize(new Dimension(700, 500));
        optionPane.setOpaque(true);
        optionPane.setBackground(Color.WHITE);
        optionPane.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int option;
                Object value = e.getNewValue();
                if (value instanceof Integer && (option = ((Integer)value).intValue()) == 0 && trackFilterPane.isFilterValid()) {
                    trackFilterPane.applyFilterMatching();
                    trackFilterPane.save();
                }
            }
        });
        JDialog dialog = optionPane.createDialog(parent, title);
        dialog.setBackground(Color.WHITE);
        dialog.getContentPane().setBackground(Color.WHITE);
        Dimension maximumSize = new Dimension(dialog.getSize().width, 100);
        if (maximumSize != null) {
            dialog.setMaximumSize(maximumSize);
        }
        if ((children = optionPane.getComponents()) != null) {
            for (Component child : children) {
                child.setBackground(Color.WHITE);
            }
        }
        dialog.pack();
        dialog.setVisible(true);
        Object selectedValue = optionPane.getValue();
        if (selectedValue == null) {
            return 2;
        }
        if ((Integer)selectedValue == 0 && !trackFilterPane.isFilterValid() && !this.showAllTracksFilterCheckBox.isSelected()) {
            JOptionPane.showMessageDialog(parent, "Some of the filter values are missing.\nPlease enter all value before pressing ok.");
            selectedValue = null;
        }
        return (Integer)selectedValue;
    }

    private void filterTracks(TrackFilterPane trackFilterPane) {
        boolean showAllTracks = this.showAllTracksFilterCheckBox.isSelected();
        if (showAllTracks) {
            List<Track> tracks = IGV.getInstance().getAllTracks(false);
            for (Track track : tracks) {
                track.setVisible(showAllTracks);
            }
        } else {
            TrackFilter filter = trackFilterPane.getFilter();
            IGV.getInstance().getSession().setFilter(filter);
            filter.evaluate();
        }
    }

    public void resetTrackFilter() {
        this.trackFilterPane = null;
        IGV.getInstance().getSession().setFilter(null);
        this.setFilterShowAllTracks(false);
    }

    public void setFilterShowAllTracks(boolean value) {
        if (this.showAllTracksFilterCheckBox != null) {
            this.showAllTracksFilterCheckBox.setSelected(value);
        }
    }

    public JCheckBox getShowAllTracksFilterCheckBox() {
        return this.showAllTracksFilterCheckBox;
    }

    public void updateTrackFilter() {
        TrackFilter trackFilter = IGV.getInstance().getSession().getFilter();
        if (trackFilter == null) {
            return;
        }
        List<String> uniqueAttributeKeys = AttributeManager.getInstance().getAttributeNames();
        if (uniqueAttributeKeys == null || uniqueAttributeKeys.isEmpty()) {
            MessageUtils.showMessage("No attributes found to use in a filter");
            return;
        }
        this.trackFilterPane = new TrackFilterPane(uniqueAttributeKeys, "Show tracks whose attribute", trackFilter);
        this.trackFilterPane.clearTracks();
        this.trackFilterPane.addTracks(IGV.getInstance().getAllTracks(false));
        trackFilter.evaluate();
    }

    public void setFilterMatchAll(boolean value) {
        if (this.trackFilterPane != null) {
            this.trackFilterPane.setMatchAll(value);
        }
    }

    public boolean isFilterMatchAll() {
        if (this.trackFilterPane != null) {
            return this.trackFilterPane.getMatchAll();
        }
        return false;
    }
}

