/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.Globals;
import org.broad.igv.hic.HiCGlobals;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.Dataset;
import org.broad.igv.hic.data.DatasetReader;
import org.broad.igv.hic.data.Matrix;
import org.broad.igv.hic.data.MatrixZoomData;
import org.broad.igv.hic.tools.AlignmentsSorter;
import org.broad.igv.hic.tools.AsciiToBinConverter;
import org.broad.igv.hic.tools.Preprocessor;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;
import org.broad.tribble.util.SeekableStream;

public class HiCTools {
    public static void main(String[] argv) throws IOException, CmdLineParser.UnknownOptionException, CmdLineParser.IllegalOptionValueException {
        if (argv.length < 4) {
            System.out.println("Usage: hictools pre <options> <inputFile> <outputFile> <genomeID>");
            System.out.println("  <options>: -d only calculate intra chromosome (diagonal) [false]");
            System.out.println("           : -o calculate densities (observed/expected), write to file [false]");
            System.out.println("           : -t <int> only write cells with count above threshold t [0]");
            System.out.println("           : -c <chromosome ID> only calculate map on specific chromosome");
            System.exit(0);
        }
        Globals.setHeadless(true);
        CommandLineParser parser = new CommandLineParser();
        parser.parse(argv);
        String[] args = parser.getRemainingArgs();
        if (args[0].equals("sort")) {
            AlignmentsSorter.sort(args[1], args[2], null);
        } else if (args[0].equals("pairsToBin")) {
            String ifile = args[1];
            String ofile = args[2];
            String genomeId = args[3];
            List<Chromosome> chromosomes = HiCTools.loadChromosomes(genomeId);
            AsciiToBinConverter.convert(ifile, ofile, chromosomes);
        } else if (args[0].equals("printmatrix")) {
            if (args.length < 5) {
                System.err.println("Usage: hictools printmatrix hicFile chr1 chr2 binsize");
            }
            String file = args[1];
            String chr1 = args[2];
            String chr2 = args[3];
            String binSizeSt = args[4];
            int binSize = 0;
            try {
                binSize = Integer.parseInt(binSizeSt);
            }
            catch (NumberFormatException e) {
                System.err.println("Integer expected.  Found: " + binSizeSt);
            }
            HiCTools.dumpMatrix(file, chr1, chr2, binSize);
        } else if (args[0].equals("pre")) {
            String genomeId = "";
            try {
                genomeId = args[3];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("No genome ID given");
                System.exit(0);
            }
            List<Chromosome> chromosomes = HiCTools.loadChromosomes(genomeId);
            long genomeLength = 0L;
            for (Chromosome c : chromosomes) {
                if (c == null) continue;
                genomeLength += (long)c.getSize();
            }
            chromosomes.set(0, new Chromosome(0, "All", (int)(genomeLength / 1000L)));
            String[] tokens = args[1].split(",");
            ArrayList<String> files = new ArrayList<String>(tokens.length);
            for (String f : tokens) {
                files.add(f);
            }
            Preprocessor preprocessor = new Preprocessor(new File(args[2]), chromosomes);
            preprocessor.setIncludedChromosomes(parser.getChromosomeOption());
            preprocessor.setCountThreshold(parser.getCountThresholdOption());
            preprocessor.setNumberOfThreads(parser.getThreadedOption());
            preprocessor.setDiagonalsOnly(parser.getDiagonalsOption());
            preprocessor.setLoadDensities(parser.getDensitiesOption());
            preprocessor.preprocess(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Chromosome> loadChromosomes(String idOrFile) throws IOException {
        InputStream is = null;
        try {
            String nextLine;
            is = HiCTools.class.getResourceAsStream(idOrFile + ".chrom.sizes");
            if (is == null) {
                File file = new File(idOrFile);
                if (file.exists()) {
                    is = new FileInputStream(file);
                } else {
                    throw new FileNotFoundException("Could not find chromosome sizes file for: " + idOrFile);
                }
            }
            ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
            chromosomes.add(0, null);
            Pattern pattern = Pattern.compile("\t");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            long genomeLength = 0L;
            int idx = 1;
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = pattern.split(nextLine);
                if (tokens.length == 2) {
                    String name = tokens[0];
                    int length = Integer.parseInt(tokens[1]);
                    genomeLength += (long)length;
                    chromosomes.add(idx, new Chromosome(idx, name, length));
                    ++idx;
                    continue;
                }
                System.out.println("Skipping " + nextLine);
            }
            chromosomes.set(0, new Chromosome(0, "All", (int)(genomeLength / 1000L)));
            ArrayList<Chromosome> arrayList = chromosomes;
            return arrayList;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterBam(String inputBam, String outputFile, List<Chromosome> chromosomes) throws IOException {
        CloseableIterator<Alignment> iter = null;
        AlignmentReader reader = null;
        PrintWriter pw = null;
        HashSet<Chromosome> allChroms = new HashSet<Chromosome>(chromosomes);
        try {
            pw = new PrintWriter(new FileWriter(outputFile));
            reader = AlignmentReaderFactory.getReader(inputBam, false);
            iter = reader.iterator();
            while (iter.hasNext()) {
                Alignment alignment = (Alignment)iter.next();
                ReadMate mate = alignment.getMate();
                if (!alignment.isPaired() || !alignment.isMapped() || alignment.getMappingQuality() <= 10 || mate == null || !mate.isMapped() || !allChroms.contains(alignment.getChr()) || !allChroms.contains(mate.getChr()) || alignment.getChr().equals(mate.getChr()) && alignment.getInferredInsertSize() <= 1000 || alignment.getStart() >= mate.getStart()) continue;
                String strand = alignment.isNegativeStrand() ? "-" : "+";
                String mateStrand = mate.isNegativeStrand() ? "-" : "+";
                pw.println(alignment.getReadName() + "\t" + alignment.getChr() + "\t" + alignment.getStart() + "\t" + strand + "\t.\t" + mate.getChr() + "\t" + mate.getStart() + "\t" + mateStrand);
            }
        }
        finally {
            pw.close();
            iter.close();
            reader.close();
        }
    }

    static void dumpMatrix(String file, String chr1, String chr2, int binsize) throws IOException {
        int zoomIdx;
        if (!file.endsWith("hic")) {
            System.err.println("Only 'hic' files are supported");
            System.exit(-1);
        }
        SeekableStream ss = IGVSeekableStreamFactory.getStreamFor(file);
        Dataset dataset = new DatasetReader(ss).read();
        Chromosome[] tmp = dataset.getChromosomes();
        HashMap<String, Chromosome> chromosomeMap = new HashMap<String, Chromosome>();
        for (Chromosome c : tmp) {
            chromosomeMap.put(c.getName(), c);
        }
        if (!chromosomeMap.containsKey(chr1)) {
            System.err.println("Unknown chromosome: " + chr1);
            System.exit(-1);
        } else if (!chromosomeMap.containsKey(chr2)) {
            System.err.println("Unknown chromosome: " + chr2);
            System.exit(-1);
        }
        boolean found = false;
        for (zoomIdx = 0; zoomIdx < HiCGlobals.zoomBinSizes.length; ++zoomIdx) {
            if (HiCGlobals.zoomBinSizes[zoomIdx] != binsize) continue;
            found = true;
            break;
        }
        if (!found) {
            System.err.println("Unknown bin size: " + binsize);
        }
        Matrix matrix = dataset.getMatrix((Chromosome)chromosomeMap.get(chr1), (Chromosome)chromosomeMap.get(chr2));
        MatrixZoomData zd = matrix.getObservedMatrix(zoomIdx);
        zd.dump();
    }

    static class CommandLineParser
    extends CmdLineParser {
        private CmdLineParser.Option diagonalsOption = this.addBooleanOption('d', "diagonals");
        private CmdLineParser.Option chromosomeOption = this.addStringOption('c', "chromosomes");
        private CmdLineParser.Option countThresholdOption = this.addIntegerOption('m', "minCountThreshold");
        private CmdLineParser.Option loadDensititesOption = this.addBooleanOption('o', "density");
        private CmdLineParser.Option threadedOption = this.addIntegerOption('t', "threads");

        CommandLineParser() {
        }

        boolean getDiagonalsOption() {
            Object opt = this.getOptionValue(this.diagonalsOption);
            return opt == null ? false : (Boolean)opt;
        }

        boolean getDensitiesOption() {
            Object opt = this.getOptionValue(this.loadDensititesOption);
            return opt == null ? false : (Boolean)opt;
        }

        Set<String> getChromosomeOption() {
            Object opt = this.getOptionValue(this.chromosomeOption);
            if (opt != null) {
                String[] tokens = opt.toString().split(",");
                return new HashSet<String>(Arrays.asList(tokens));
            }
            return null;
        }

        int getCountThresholdOption() {
            Object opt = this.getOptionValue(this.countThresholdOption);
            return opt == null ? 0 : ((Number)opt).intValue();
        }

        int getThreadedOption() {
            Object opt = this.getOptionValue(this.threadedOption);
            return opt == null ? 0 : ((Number)opt).intValue();
        }
    }
}

