/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.dev.db.DBReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.util.ResourceLocator;

public class SampleInfoSQLReader
extends DBReader {
    private static Logger log = Logger.getLogger(SampleInfoSQLReader.class);
    String sampleColumn = "SAMPLE_ID_ARRAY";

    public void load(ResourceLocator locator) {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = DBManager.getConnection();
            String query = locator.getDescription();
            st = conn.createStatement();
            rs = st.executeQuery(query);
            ResultSetMetaData metaData = rs.getMetaData();
            int nCol = metaData.getColumnCount();
            String[] columnNames = new String[nCol];
            for (int i = 0; i < nCol; ++i) {
                columnNames[i] = metaData.getColumnName(i + 1);
            }
            while (rs.next()) {
                String sample = rs.getString(this.sampleColumn);
                for (String col : columnNames) {
                    String value = rs.getString(col);
                    AttributeManager.getInstance().addAttribute(sample, col, value);
                }
            }
        }
        catch (Exception e) {
            try {
                log.error("Error accessing database", e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SampleInfoSQLReader.closeResources(rs, st, conn);
                throw throwable;
            }
        }
        SampleInfoSQLReader.closeResources(rs, st, conn);
    }
}

