/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.DenseAlignmentCounts;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.SparseAlignmentCounts;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.ReadGroupFilter;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.ObjectCache;
import org.broad.igv.util.RuntimeUtils;
import org.broad.tribble.Feature;

public class CachingQueryReader {
    private static Logger log = Logger.getLogger(CachingQueryReader.class);
    private static final int KB = 1000;
    private static final int MITOCHONDRIA_TILE_SIZE = 1000;
    private static int MAX_TILE_COUNT = 10;
    private static Set<WeakReference<CachingQueryReader>> activeReaders = Collections.synchronizedSet(new HashSet());
    private boolean corruptIndex = false;
    private float visibilityWindow = 16.0f;
    private String cachedChr = "";
    private int tileSize;
    private AlignmentReader reader;
    private boolean cancel = false;
    private LRUCache<Integer, AlignmentTile> cache;
    private boolean pairedEnd = false;

    private static void cancelReaders() {
        for (WeakReference<CachingQueryReader> readerRef : activeReaders) {
            CachingQueryReader reader = (CachingQueryReader)readerRef.get();
            if (reader == null) continue;
            reader.cancel = true;
        }
        log.debug("Readers canceled");
        activeReaders.clear();
    }

    public CachingQueryReader(AlignmentReader reader) {
        this.reader = reader;
        activeReaders.add(new WeakReference<CachingQueryReader>(this));
        this.updateCache();
    }

    public static void visibilityWindowChanged() {
        for (WeakReference<CachingQueryReader> readerRef : activeReaders) {
            CachingQueryReader reader = (CachingQueryReader)readerRef.get();
            if (reader == null) continue;
            reader.updateCache();
        }
    }

    private void updateCache() {
        float fvw = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float ratio = fvw / this.visibilityWindow;
        if (this.cache == null || (double)ratio < 0.5 || ratio > 2.0f) {
            this.tileSize = (int)(fvw * 1000.0f);
            this.cache = new LRUCache(this, MAX_TILE_COUNT);
            this.visibilityWindow = fvw;
        }
    }

    public AlignmentReader getWrappedReader() {
        return this.reader;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Set<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public SAMFileHeader getHeader() throws IOException {
        return this.reader.getHeader();
    }

    public CloseableIterator<Alignment> iterator() {
        return this.reader.iterator();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public CloseableIterator<Alignment> query(String sequence, int start, int end, List<AlignmentCounts> counts, List<SpliceJunctionFeature> spliceJunctionFeatures, List<DownsampledInterval> downsampledIntervals, AlignmentDataManager.DownsampleOptions downsampleOptions, Map<String, PEStats> peStats, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        List<SpliceJunctionFeature> tmp;
        int endTile;
        int startTile = (start + 1) / this.getTileSize(sequence);
        List<AlignmentTile> tiles = this.getTiles(sequence, startTile, endTile = end / this.getTileSize(sequence), downsampleOptions, peStats, bisulfiteContext);
        if (tiles.size() == 0) {
            return EmptyAlignmentIterator.getInstance();
        }
        int recordCount = tiles.get(0).getOverlappingRecords().size();
        for (AlignmentTile t : tiles) {
            recordCount += t.getContainedRecords().size();
        }
        ArrayList<Alignment> alignments = new ArrayList<Alignment>(recordCount);
        alignments.addAll(tiles.get(0).getOverlappingRecords());
        if (spliceJunctionFeatures != null && (tmp = tiles.get(0).getOverlappingSpliceJunctionFeatures()) != null) {
            spliceJunctionFeatures.addAll(tmp);
        }
        for (AlignmentTile t : tiles) {
            List<SpliceJunctionFeature> tmp2;
            alignments.addAll(t.getContainedRecords());
            counts.add(t.getCounts());
            downsampledIntervals.addAll(t.getDownsampledIntervals());
            if (spliceJunctionFeatures == null || (tmp2 = t.getContainedSpliceJunctionFeatures()) == null) continue;
            spliceJunctionFeatures.addAll(tmp2);
        }
        Collections.sort(alignments, new AlignmentSorter());
        return new TiledIterator(start, end, alignments);
    }

    public List<AlignmentTile> getTiles(String seq, int startTile, int endTile, AlignmentDataManager.DownsampleOptions downsampleOptions, Map<String, PEStats> peStats, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        if (!seq.equals(this.cachedChr)) {
            this.cache.clear();
            this.cachedChr = seq;
        }
        ArrayList<AlignmentTile> tiles = new ArrayList<AlignmentTile>(endTile - startTile + 1);
        ArrayList<AlignmentTile> tilesToLoad = new ArrayList<AlignmentTile>(endTile - startTile + 1);
        int tileSize = this.getTileSize(seq);
        for (int t = startTile; t <= endTile; ++t) {
            AlignmentTile tile = this.cache.get(t);
            if (tile == null) {
                int start = t * tileSize;
                int end = start + tileSize;
                tile = new AlignmentTile(t, start, end, downsampleOptions, bisulfiteContext);
            }
            tiles.add(tile);
            if (tile.isLoaded()) {
                boolean success;
                if (tilesToLoad.size() > 0 && !(success = this.loadTiles(seq, tilesToLoad, peStats))) {
                    return tiles;
                }
                tilesToLoad.clear();
                continue;
            }
            tilesToLoad.add(tile);
        }
        if (tilesToLoad.size() > 0) {
            this.loadTiles(seq, tilesToLoad, peStats);
        }
        return tiles;
    }

    private boolean loadTiles(String chr, List<AlignmentTile> tiles, Map<String, PEStats> peStats) {
        int end;
        if (this.corruptIndex) {
            return false;
        }
        boolean filterFailedReads = PreferenceManager.getInstance().getAsBoolean("SAM.FILTER_FAILED_READS");
        ReadGroupFilter filter = ReadGroupFilter.getFilter();
        boolean showDuplicates = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_DUPLICATES");
        int qualityThreshold = PreferenceManager.getInstance().getAsInt("SAM.QUALITY_THRESHOLD");
        if (log.isDebugEnabled()) {
            int first = tiles.get(0).getTileNumber();
            end = tiles.get(tiles.size() - 1).getTileNumber();
            log.debug("Loading tiles: " + first + "-" + end);
        }
        int start = tiles.get(0).start;
        end = tiles.get(tiles.size() - 1).end;
        CloseableIterator<Alignment> iter = null;
        int alignmentCount = 0;
        WeakReference<CachingQueryReader> ref = new WeakReference<CachingQueryReader>(this);
        try {
            ObjectCache<String, Alignment> mappedMates = new ObjectCache<String, Alignment>(1000);
            ObjectCache<String, Alignment> unmappedMates = new ObjectCache<String, Alignment>(1000);
            activeReaders.add(ref);
            iter = this.reader.query(chr, start, end, false);
            int tileSize = this.getTileSize(chr);
            while (iter != null && iter.hasNext()) {
                PEStats stats;
                int interval;
                if (this.cancel) {
                    boolean bl = false;
                    return bl;
                }
                Alignment record = (Alignment)iter.next();
                String readName = record.getReadName();
                if (record.isPaired()) {
                    this.pairedEnd = true;
                    if (record.isMapped()) {
                        if (!record.getMate().isMapped()) {
                            Alignment mate = (Alignment)unmappedMates.get(readName);
                            if (mate == null) {
                                mappedMates.put(readName, record);
                            } else {
                                record.setMateSequence(mate.getReadSequence());
                                unmappedMates.remove(readName);
                                mappedMates.remove(readName);
                            }
                        }
                    } else if (record.getMate().isMapped()) {
                        Alignment mappedMate = (Alignment)mappedMates.get(readName);
                        if (mappedMate == null) {
                            unmappedMates.put(readName, record);
                        } else {
                            mappedMate.setMateSequence(record.getReadSequence());
                            unmappedMates.remove(readName);
                            mappedMates.remove(readName);
                        }
                    }
                }
                if (!record.isMapped() || !showDuplicates && record.isDuplicate() || filterFailedReads && record.isVendorFailedRead() || record.getMappingQuality() < qualityThreshold || filter != null && filter.filterAlignment(record)) continue;
                int aStart = record.getStart();
                int aEnd = record.getEnd();
                int idx0 = Math.max(0, (aStart - start) / tileSize);
                int idx1 = Math.min(tiles.size() - 1, (aEnd - start) / tileSize);
                for (int i = idx0; i <= idx1; ++i) {
                    AlignmentTile t = null;
                    t = tiles.get(i);
                    t.addRecord(record);
                }
                int n = interval = Globals.isTesting() ? 100000 : 1000;
                if (++alignmentCount % interval == 0) {
                    if (this.cancel) {
                        boolean t = false;
                        return t;
                    }
                    MessageUtils.setStatusBarMessage("Reads loaded: " + alignmentCount);
                    if (!CachingQueryReader.checkMemory()) {
                        CachingQueryReader.cancelReaders();
                        boolean t = false;
                        return t;
                    }
                }
                if (peStats == null || !record.isPaired() || !record.isProperPair()) continue;
                String lb = record.getLibrary();
                if (lb == null) {
                    lb = "null";
                }
                if ((stats = peStats.get(lb)) == null) {
                    stats = new PEStats(lb);
                    peStats.put(lb, stats);
                }
                stats.update(record);
            }
            if (peStats != null) {
                double minPercentile = PreferenceManager.getInstance().getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE");
                double maxPercentile = PreferenceManager.getInstance().getAsFloat("SAM.ISIZE_MAX_PERCENTILE");
                for (PEStats stats : peStats.values()) {
                    stats.compute(minPercentile, maxPercentile);
                }
            }
            for (String mappedMateName : mappedMates.getKeys()) {
                Alignment mappedMate = (Alignment)mappedMates.get(mappedMateName);
                Alignment mate = (Alignment)unmappedMates.get(mappedMate.getReadName());
                if (mate == null) continue;
                mappedMate.setMateSequence(mate.getReadSequence());
            }
            mappedMates = null;
            unmappedMates = null;
            for (AlignmentTile t : tiles) {
                t.setLoaded(true);
                this.cache.put(t.getTileNumber(), t);
            }
            boolean bl = true;
            return bl;
        }
        catch (BufferUnderflowException e) {
            this.corruptIndex = true;
            MessageUtils.showMessage("<html>Error encountered querying alignments: " + e.toString() + "<br>This is often caused by a corrupt index file.");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.error("Error loading alignment data", e);
            throw new DataLoadException("", "Error: " + e.toString());
        }
        finally {
            this.cancel = false;
            activeReaders.remove(ref);
            if (iter != null) {
                iter.close();
            }
            if (!Globals.isHeadless()) {
                IGV.getInstance().resetStatusMessage();
            }
        }
    }

    private static synchronized boolean checkMemory() {
        if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
            LRUCache.clearCaches();
            System.gc();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
                String msg = "Memory is low, reading terminating.";
                MessageUtils.showMessage(msg);
                return false;
            }
        }
        return true;
    }

    public int getTileSize(String chr) {
        if (chr.equals("M") || chr.equals("chrM") || chr.equals("MT") || chr.equals("chrMT")) {
            return 1000;
        }
        return this.tileSize;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public boolean isPairedEnd() {
        return this.pairedEnd;
    }

    public static class DownsampledInterval
    implements Feature {
        private int start;
        private int end;
        private int count;

        public DownsampledInterval(int start, int end, int count) {
            this.start = start;
            this.end = end;
            this.count = count;
        }

        public String toString() {
            return this.start + "-" + this.end + " (" + this.count + ")";
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public String getChr() {
            return null;
        }

        public String getValueString() {
            return "Interval [" + this.start + "-" + this.end + "] <br>" + this.count + " reads removed.";
        }
    }

    private static class AlignmentSorter
    implements Comparator<Alignment> {
        private AlignmentSorter() {
        }

        @Override
        public int compare(Alignment alignment, Alignment alignment1) {
            return alignment.getStart() - alignment1.getStart();
        }
    }

    public static class AlignmentTile {
        private boolean loaded = false;
        private int end;
        private int start;
        private int tileNumber;
        private AlignmentCounts counts;
        private List<Alignment> containedRecords;
        private List<Alignment> overlappingRecords;
        private List<DownsampledInterval> downsampledIntervals;
        private List<SpliceJunctionFeature> containedSpliceJunctionFeatures;
        private List<SpliceJunctionFeature> overlappingSpliceJunctionFeatures;
        private SpliceJunctionHelper spliceJunctionHelper;
        private boolean downsample;
        private int samplingWindowSize;
        private int samplingDepth;
        private SamplingBucket currentSamplingBucket;
        private static final Random RAND = new Random(System.currentTimeMillis());
        int ignoredCount = 0;

        AlignmentTile(int tileNumber, int start, int end, AlignmentDataManager.DownsampleOptions downsampleOptions, AlignmentTrack.BisulfiteContext bisulfiteContext) {
            this.tileNumber = tileNumber;
            this.start = start;
            this.end = end;
            this.containedRecords = new ArrayList<Alignment>(16000);
            this.overlappingRecords = new ArrayList<Alignment>();
            this.downsampledIntervals = new ArrayList<DownsampledInterval>();
            this.counts = end - start > 100000 ? new SparseAlignmentCounts(start, end, bisulfiteContext) : new DenseAlignmentCounts(start, end, bisulfiteContext);
            if (downsampleOptions == null) {
                downsampleOptions = new AlignmentDataManager.DownsampleOptions();
            }
            this.downsample = downsampleOptions.isDownsample();
            this.samplingWindowSize = downsampleOptions.getSampleWindowSize();
            this.samplingDepth = Math.max(1, downsampleOptions.getMaxReadCount());
            if (PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_JUNCTION_TRACK")) {
                this.containedSpliceJunctionFeatures = new ArrayList<SpliceJunctionFeature>(100);
                this.overlappingSpliceJunctionFeatures = new ArrayList<SpliceJunctionFeature>(100);
                this.spliceJunctionHelper = new SpliceJunctionHelper();
            }
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void addRecord(Alignment alignment) {
            if (this.downsample) {
                int alignmentStart = alignment.getAlignmentStart();
                if (this.currentSamplingBucket == null || alignmentStart >= this.currentSamplingBucket.end) {
                    if (this.currentSamplingBucket != null) {
                        this.emptyBucket();
                    }
                    int end = alignmentStart + this.samplingWindowSize;
                    this.currentSamplingBucket = new SamplingBucket(alignmentStart, end);
                }
                this.counts.incCounts(alignment);
                if (this.spliceJunctionHelper != null) {
                    this.spliceJunctionHelper.addAlignment(alignment);
                }
                this.currentSamplingBucket.add(alignment);
            } else {
                this.allocateAlignment(alignment);
            }
        }

        private void emptyBucket() {
            if (this.currentSamplingBucket == null) {
                return;
            }
            for (Alignment alignment : this.currentSamplingBucket.getAlignments()) {
                this.allocateAlignment(alignment);
            }
            if (this.currentSamplingBucket.isSampled()) {
                DownsampledInterval interval = new DownsampledInterval(this.currentSamplingBucket.start, this.currentSamplingBucket.end, this.currentSamplingBucket.downsampledCount);
                this.downsampledIntervals.add(interval);
            }
            this.currentSamplingBucket = null;
        }

        private void allocateAlignment(Alignment alignment) {
            int aStart = alignment.getStart();
            int aEnd = alignment.getEnd();
            if (aStart >= this.start && aStart < this.end) {
                this.containedRecords.add(alignment);
            } else if (aEnd > this.start && aStart < this.start) {
                this.overlappingRecords.add(alignment);
            }
        }

        public List<Alignment> getContainedRecords() {
            return this.containedRecords;
        }

        public List<Alignment> getOverlappingRecords() {
            return this.overlappingRecords;
        }

        public List<DownsampledInterval> getDownsampledIntervals() {
            return this.downsampledIntervals;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
            if (loaded) {
                this.emptyBucket();
                this.currentSamplingBucket = null;
                this.finalizeSpliceJunctions();
            }
        }

        public AlignmentCounts getCounts() {
            return this.counts;
        }

        private void finalizeSpliceJunctions() {
            if (this.spliceJunctionHelper != null) {
                this.spliceJunctionHelper.finish();
                List<SpliceJunctionFeature> features = this.spliceJunctionHelper.getFeatures();
                for (SpliceJunctionFeature f : features) {
                    if (f.getStart() >= this.start) {
                        this.containedSpliceJunctionFeatures.add(f);
                        continue;
                    }
                    this.overlappingSpliceJunctionFeatures.add(f);
                }
            }
            this.spliceJunctionHelper = null;
        }

        public List<SpliceJunctionFeature> getContainedSpliceJunctionFeatures() {
            return this.containedSpliceJunctionFeatures;
        }

        public List<SpliceJunctionFeature> getOverlappingSpliceJunctionFeatures() {
            return this.overlappingSpliceJunctionFeatures;
        }

        private class SamplingBucket {
            int start;
            int end;
            int downsampledCount = 0;
            List<Alignment> alignments;

            private SamplingBucket(int start, int end) {
                this.start = start;
                this.end = end;
                this.alignments = new ArrayList<Alignment>(AlignmentTile.this.samplingDepth);
            }

            public void add(Alignment alignment) {
                if (this.alignments.size() < AlignmentTile.this.samplingDepth) {
                    this.alignments.add(alignment);
                } else {
                    double samplingProb = (double)AlignmentTile.this.samplingDepth / (double)(AlignmentTile.this.samplingDepth + this.downsampledCount + 1);
                    if (RAND.nextDouble() < samplingProb) {
                        int idx = (int)(RAND.nextDouble() * (double)(this.alignments.size() - 1));
                        this.alignments.set(idx, alignment);
                    }
                    ++this.downsampledCount;
                }
            }

            public List<Alignment> getAlignments() {
                return this.alignments;
            }

            public boolean isSampled() {
                return this.downsampledCount > 0;
            }

            public int getDownsampledCount() {
                return this.downsampledCount;
            }
        }
    }

    public class TiledIterator
    implements CloseableIterator<Alignment> {
        Iterator<Alignment> currentSamIterator;
        int end;
        Alignment nextRecord;
        int start;
        List<Alignment> alignments;

        TiledIterator(int start, int end, List<Alignment> alignments) {
            this.alignments = alignments;
            this.start = start;
            this.end = end;
            this.currentSamIterator = alignments.iterator();
            this.advanceToFirstRecord();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Alignment next() {
            Alignment ret = this.nextRecord;
            this.advanceToNextRecord();
            return ret;
        }

        @Override
        public void remove() {
        }

        private void advanceToFirstRecord() {
            this.advanceToNextRecord();
        }

        private void advanceToNextRecord() {
            this.advance();
            while (this.nextRecord != null && this.nextRecord.getEnd() <= this.start) {
                this.advance();
            }
        }

        private void advance() {
            if (this.currentSamIterator.hasNext()) {
                this.nextRecord = this.currentSamIterator.next();
                if (this.nextRecord.getStart() >= this.end) {
                    this.nextRecord = null;
                }
            } else {
                this.nextRecord = null;
            }
        }
    }
}

