/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.reads;

import com.google.protobuf.GeneratedMessage;
import edu.cornell.med.icb.goby.exception.GobyRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageChunksReader
implements Closeable {
    private static final Log LOG = LogFactory.getLog(MessageChunksReader.class);
    protected DataInputStream in;
    protected int entryIndex;
    protected GZIPInputStream uncompressStream;
    long bytesRead = 0L;

    protected MessageChunksReader() {
    }

    public MessageChunksReader(InputStream input) {
        assert (input != null) : "The input stream must not be null";
        this.in = new DataInputStream(input);
    }

    public boolean hasNext(GeneratedMessage collection, int collectionSize) {
        if (collection == null || this.entryIndex >= collectionSize) {
            if (this.in == null) {
                return false;
            }
            try {
                long numSkipped = this.in.skip(8L);
                this.bytesRead += numSkipped;
                if (numSkipped != 8L) {
                    LOG.warn("Skip returned " + numSkipped);
                    this.uncompressStream = null;
                    return false;
                }
                int numBytes = this.in.readInt();
                this.bytesRead += 4L;
                if (numBytes == 0) {
                    this.uncompressStream = null;
                    return false;
                }
                byte[] bytes = new byte[numBytes];
                int numRead = this.in.read(bytes);
                this.bytesRead += (long)numBytes;
                if (numRead != numBytes) {
                    LOG.warn("Expected " + numBytes + " but got " + numRead);
                }
                this.uncompressStream = new GZIPInputStream(new ByteArrayInputStream(bytes));
                this.entryIndex = 0;
                return true;
            }
            catch (IOException e) {
                throw new GobyRuntimeException(e);
            }
        }
        this.uncompressStream = null;
        return this.entryIndex < collectionSize;
    }

    public GZIPInputStream getUncompressStream() {
        return this.uncompressStream;
    }

    public int incrementEntryIndex() {
        return this.entryIndex++;
    }

    public int getEntryIndex() {
        return this.entryIndex;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.uncompressStream);
        IOUtils.closeQuietly(this.in);
    }

    public long position() throws IOException {
        return this.bytesRead;
    }
}

