/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.methyl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.BigBedIterator;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.methyl.MethylDataSource;
import org.broad.igv.methyl.MethylScore;

public class BBMethylDataSource
implements MethylDataSource {
    static Pattern percentPattern = Pattern.compile("%");
    BBFileReader reader;
    Map<String, String> chrNameMap;

    public BBMethylDataSource(String path, Genome genome) throws IOException {
        this.reader = new BBFileReader(path);
        this.init(genome);
    }

    @Override
    public Iterator<MethylScore> query(String chr, int start, int end) {
        String tmp = this.chrNameMap.get(chr);
        String querySeq = tmp == null ? chr : tmp;
        BigBedIterator bedIterator = this.reader.getBigBedIterator(querySeq, start, chr, end, false);
        return new WrappedIterator(bedIterator);
    }

    private void init(Genome genome) {
        ArrayList<String> seqNames;
        this.chrNameMap = new HashMap<String, String>();
        if (genome != null && (seqNames = this.reader.getChromosomeNames()) != null) {
            for (String seqName : seqNames) {
                String igvChr = genome.getChromosomeAlias(seqName);
                if (igvChr == null || igvChr.equals(seqName)) continue;
                this.chrNameMap.put(igvChr, seqName);
            }
        }
    }

    public static class WrappedIterator
    implements Iterator<MethylScore> {
        BigBedIterator bedIterator;

        public WrappedIterator(BigBedIterator bedIterator) {
            this.bedIterator = bedIterator;
        }

        @Override
        public boolean hasNext() {
            return this.bedIterator.hasNext();
        }

        @Override
        public MethylScore next() {
            BedFeature feat = null;
            while (feat == null && this.bedIterator.hasNext()) {
                short count;
                feat = this.bedIterator.next();
                String[] restOfFields = feat.getRestOfFields();
                String name = restOfFields[0];
                String[] tokens = percentPattern.split(name.replace("'", "").replace("[", "").replace("]", ""));
                if (tokens.length != 2) continue;
                short percent = 0;
                try {
                    percent = Short.parseShort(tokens[0]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                try {
                    count = Short.parseShort(tokens[1]);
                }
                catch (NumberFormatException e) {
                    count = Short.MAX_VALUE;
                }
                return new MethylScore(feat.getChromosome(), feat.getStartBase(), feat.getEndBase(), percent, count);
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

