/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ProgressMonitor {
    public static final String PROGRESS_PROPERTY = "PROGRESS_PROPERTY";
    private boolean isReady = false;
    private int oldValue = 0;
    private Object source = this;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this.source);

    public ProgressMonitor() {
        this.setReady(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void fireProgressChange(int value) {
        if (this.isReady) {
            int newValue = this.oldValue + value;
            PropertyChangeEvent event = new PropertyChangeEvent(this.source, PROGRESS_PROPERTY, this.oldValue, newValue);
            this.propertyChangeSupport.firePropertyChange(event);
            this.oldValue = newValue;
        }
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public boolean isReady() {
        return this.isReady;
    }
}

