/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;

public class RuntimeUtils {
    private static Instrumentation instrumentation;

    public static long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return freeMemory + (maxMemory - allocatedMemory);
    }

    public static double getAvailableMemoryFraction() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return (double)(freeMemory + (maxMemory - allocatedMemory)) / (double)maxMemory;
    }

    public static void premain(String args, Instrumentation inst) {
        instrumentation = inst;
    }

    public static long getObjectSize(Object o) {
        if (instrumentation == null) {
            throw new IllegalStateException("No instrumentation available. Need to launch width -javaagent:path/to/RuntimeUtils.jar");
        }
        return instrumentation.getObjectSize(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process startExternalProcess(String msg, String[] envp, File dir) {
        Runtime run = Runtime.getRuntime();
        Process pr = null;
        try {
            pr = run.exec(msg, envp, dir);
            return pr;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return pr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeShellCommand(String cmd, String[] envp, File dir) throws IOException {
        Process pr = RuntimeUtils.startExternalProcess(cmd, envp, dir);
        try {
            pr.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        InputStream inputStream = null;
        String line = "";
        try {
            inputStream = pr.getInputStream();
            BufferedReader buf = new BufferedReader(new InputStreamReader(inputStream));
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            while ((line = buf.readLine()) != null) {
                pw.println(line);
            }
            pw.close();
            String string = writer.toString();
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

