/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;

public class EigenvectorTrack
extends AbstractTrack {
    double step;
    double[] data;
    private double dataMax;

    public EigenvectorTrack(String id, String name) {
        super(id, name);
    }

    public void setData(double step, double[] data) {
        this.step = step;
        this.data = data;
        this.dataMax = 0.0;
        for (double aData : data) {
            if (!(Math.abs(aData) > this.dataMax)) continue;
            this.dataMax = Math.abs(aData);
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        if (this.data == null) {
            return;
        }
        int h = rect.height / 2;
        Graphics2D g2d = context.getGraphics();
        g2d.setColor(Color.blue.darker());
        int lastXPixel = -1;
        for (int i = 0; i < this.data.length; ++i) {
            int genomicPosition = (int)(this.step * (double)i);
            int xPixel = context.bpToScreenPixel(genomicPosition);
            if (xPixel > lastXPixel && lastXPixel >= 0) {
                int myh = (int)(this.data[i] / this.dataMax * (double)h);
                if (this.data[i] > 0.0) {
                    g2d.fillRect(lastXPixel, h - myh, xPixel - lastXPixel, myh);
                } else {
                    System.out.println(h + " " + myh);
                    g2d.fillRect(lastXPixel, h, xPixel - lastXPixel, -myh);
                }
            }
            lastXPixel = xPixel;
        }
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }
}

