/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.example;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;

public class ProfileIndexReading {
    private static Logger logger = Logger.getRootLogger();

    public static void main(String[] args) {
        BasicConfigurator.configure();
        logger.setLevel(Level.ERROR);
        if (args.length < 2) {
            ProfileIndexReading.printUsage();
        }
        int iterations = Integer.valueOf(args[0]);
        for (int j = 1; j < args.length; ++j) {
            String indexFile = args[j];
            System.out.printf("Reading %s%n", indexFile);
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < iterations; ++i) {
                System.out.printf("  iteration %d%n", i);
                Index index = IndexFactory.loadIndex(indexFile);
            }
            long stopTime = System.currentTimeMillis();
            System.out.printf("Runtime %s %.2f%n", indexFile, (double)(stopTime - startTime) / 1000.0);
        }
    }

    public static void printUsage() {
        System.err.println("Usage: java -jar ReadIndices.jar iterations index.file...");
        System.exit(1);
    }
}

