/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.util.ParsingUtils;

public class FastaSequence
implements Sequence {
    Map<String, byte[]> sequenceMap;

    public FastaSequence(String path) throws IOException {
        this.readFasta(path);
    }

    @Override
    public byte[] readSequence(String chr, int qstart, int qend) {
        byte[] allBytes = this.sequenceMap.get(chr);
        if (allBytes == null) {
            return null;
        }
        int start = Math.max(0, qstart);
        int end = Math.min(allBytes.length, qend);
        int len = end - start;
        byte[] bytes = new byte[len];
        Arrays.fill(bytes, (byte)0);
        int s = Math.max(start, 0);
        System.arraycopy(allBytes, s, bytes, 0, len);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFasta(String path) throws IOException {
        this.sequenceMap = new HashMap<String, byte[]>();
        BufferedReader br = null;
        try {
            byte[] seq;
            String nextLine;
            br = ParsingUtils.openBufferedReader(path);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(10000);
            String currentChr = null;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#") || nextLine.trim().length() == 0) continue;
                if (nextLine.startsWith(">")) {
                    if (currentChr != null) {
                        seq = buffer.toByteArray();
                        this.sequenceMap.put(currentChr, seq);
                        buffer.reset();
                    }
                    currentChr = nextLine.substring(1).split("\\s+")[0];
                    continue;
                }
                buffer.write(nextLine.trim().getBytes());
            }
            if (currentChr != null) {
                seq = buffer.toByteArray();
                this.sequenceMap.put(currentChr, seq);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

