/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.rnai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.rnai.RNAIGeneScore;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

public class RNAIDataSource
implements DataSource {
    private String screen;
    private String condition;
    private String displayName;
    private boolean scoresAreSorted = false;
    private Genome genome;
    Map<String, List<LocusScore>> dataMap;
    static List<WindowFunction> emptyList = new ArrayList<WindowFunction>();

    public RNAIDataSource(String screen, String condition, Genome genome) {
        this.genome = genome;
        this.screen = screen;
        this.condition = condition;
        this.displayName = screen;
        if (condition != null && condition.length() > 0) {
            this.displayName = this.displayName + " (" + condition + " )";
        }
        this.dataMap = new HashMap<String, List<LocusScore>>();
    }

    public void addGeneScore(RNAIGeneScore dpt) {
        String chr = dpt.getGene().getChr();
        List<LocusScore> chrDataPoints = this.dataMap.get(chr);
        if (chrDataPoints == null) {
            chrDataPoints = new ArrayList<LocusScore>(500);
            this.dataMap.put(chr, chrDataPoints);
        }
        chrDataPoints.add(dpt);
        List<LocusScore> chrAllScores = this.dataMap.get("All");
        if (chrAllScores == null) {
            chrAllScores = new ArrayList<LocusScore>(500);
            this.dataMap.put("All", chrAllScores);
        }
        if (this.genome != null) {
            RNAIGeneScore genomeScore = new RNAIGeneScore(dpt);
            int genomeStart = this.genome.getGenomeCoordinate(dpt.getGene().getChr(), dpt.getStart());
            int genomeEnd = this.genome.getGenomeCoordinate(dpt.getGene().getChr(), dpt.getEnd());
            genomeScore.setStart(genomeStart);
            genomeScore.setEnd(genomeEnd);
            chrAllScores.add(genomeScore);
        }
    }

    private void sortScores() {
        for (List<LocusScore> scores : this.dataMap.values()) {
            FeatureUtils.sortFeatureList(scores);
        }
    }

    @Override
    public double getDataMax() {
        return 3.0;
    }

    @Override
    public double getDataMin() {
        return -3.0;
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        if (!this.scoresAreSorted) {
            this.sortScores();
        }
        return this.dataMap.get(chr);
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.RNAI;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    public void refreshData(long timestamp) {
    }

    public String getScreen() {
        return this.screen;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getName() {
        return this.displayName;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return emptyList;
    }
}

