/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.sam.Alignment;

public class PEStats {
    private static Logger log = Logger.getLogger(PEStats.class);
    private static int MAX = 10000;
    String library;
    int nPairs = 0;
    private double[] insertSizes = new double[MAX];
    private int minThreshold = 10;
    private int maxThreshold = 5000;
    int frCount = 0;
    int ffCount = 0;
    int rfCount = 0;
    Orientation orientation = null;

    public PEStats(String library) {
        this.library = library;
    }

    public void update(Alignment alignment) {
        String po;
        if (this.nPairs < this.insertSizes.length) {
            this.insertSizes[this.nPairs] = Math.abs(alignment.getInferredInsertSize());
            ++this.nPairs;
        }
        if ((po = alignment.getPairOrientation()) != null && po.length() == 4) {
            if (po.charAt(0) == 'F') {
                if (po.charAt(2) == 'F') {
                    ++this.ffCount;
                } else if (po.charAt(2) == 'R') {
                    ++this.frCount;
                }
            } else if (po.charAt(0) == 'R') {
                if (po.charAt(2) == 'F') {
                    ++this.rfCount;
                } else if (po.charAt(2) == 'R') {
                    ++this.ffCount;
                }
            }
        }
        this.orientation = null;
    }

    public void compute(double minPercentile, double maxPercentile) {
        if (this.nPairs > 100 && this.insertSizes != null) {
            this.minThreshold = (int)StatUtils.percentile(this.insertSizes, 0, this.nPairs, minPercentile);
            this.maxThreshold = (int)StatUtils.percentile(this.insertSizes, 0, this.nPairs, maxPercentile);
        }
    }

    public int getMinThreshold() {
        return this.minThreshold;
    }

    public int getMaxThreshold() {
        return this.maxThreshold;
    }

    public Orientation getOrientation() {
        if (this.orientation == null) {
            this.orientation = this.ffCount > this.frCount && this.ffCount > this.rfCount ? Orientation.FF : (this.rfCount > this.frCount && this.rfCount > this.ffCount ? Orientation.RF : Orientation.FR);
        }
        return this.orientation;
    }

    public static enum Orientation {
        FR,
        RF,
        FF;

    }
}

