/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.igv.util.HttpUtils;
import org.broad.tribble.util.SeekableStream;

public class SeekableServiceStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableServiceStream.class);
    private static final String WEBSERVICE_URL = "http://www.broadinstitute.org/webservices/igv/range";
    private long position = 0L;
    private long contentLength = Long.MAX_VALUE;
    private URL wrappedURL;

    public SeekableServiceStream(URL url) {
        this.wrappedURL = url;
    }

    @Override
    public long length() {
        if (this.contentLength == Long.MAX_VALUE) {
            try {
                this.contentLength = HttpUtils.getInstance().getContentLength(this.wrappedURL);
            }
            catch (IOException e) {
                log.error("Error fetching content length for: " + this.wrappedURL, e);
            }
        }
        return this.contentLength;
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.contentLength;
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        this.position += n;
        return n;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n;
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        InputStream is = null;
        URL url = new URL("http://www.broadinstitute.org/webservices/igv/range?file=" + this.wrappedURL.toExternalForm() + "&position=" + this.position + "&length=" + length);
        try {
            int count;
            is = HttpUtils.getInstance().openConnectionStream(url);
            for (n = 0; n < length; n += count) {
                count = is.read(buffer, offset + n, length - n);
                if (count >= 0) continue;
                int n2 = n;
                return n2;
            }
            this.position += (long)n;
            count = n;
            return count;
        }
        catch (IOException e) {
            if (e.getMessage().contains("416") || e instanceof EOFException) {
                int n3 = n;
                return n3;
            }
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] readBytes(long position, int nBytes) throws IOException {
        this.position = position;
        byte[] buffer = new byte[nBytes];
        this.read(buffer, 0, nBytes);
        return buffer;
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableServiceStream.  Must read in blocks.");
    }
}

