/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.jdesktop.layout.GroupLayout;

public class GenomeSelectionDialog
extends JDialog {
    private boolean isCanceled = true;
    private JComboBox genomeComboBox;
    private JLabel genomeComboBoxLabel;
    private JButton okButton;
    private JButton cancelButton;

    public GenomeSelectionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public void setModel(ComboBoxModel model) {
        this.genomeComboBox.setModel(model);
    }

    public GenomeDescriptor getSelectedItem() {
        return this.isCanceled ? null : (GenomeDescriptor)this.genomeComboBox.getSelectedItem();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCancelingEnabled(boolean isEnabled) {
        this.cancelButton.setEnabled(isEnabled);
    }

    public void setDefaultGenome(GenomeDescriptor genome) {
        this.genomeComboBox.setSelectedItem(genome);
    }

    private void initComponents() {
        this.genomeComboBox = new JComboBox();
        this.genomeComboBoxLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Choose Genome");
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        this.genomeComboBox.setEditable(false);
        this.genomeComboBoxLabel.setText("Genome");
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenomeSelectionDialog.this.okButtonActionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenomeSelectionDialog.this.cancelButtonActionPerformed(e);
            }
        });
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().add(2, contentPaneLayout.createSequentialGroup().add(24, 24, 24).add(contentPaneLayout.createParallelGroup().add(contentPaneLayout.createSequentialGroup().add(this.genomeComboBoxLabel).add(20, 20, 20).add(this.genomeComboBox, -1, 422, Short.MAX_VALUE)).add(2, contentPaneLayout.createSequentialGroup().addPreferredGap(0, 120, -2).add(this.okButton).addPreferredGap(0).add(this.cancelButton).add(195, 195, 195))).addContainerGap()));
        contentPaneLayout.linkSize(new Component[]{this.cancelButton, this.okButton}, 1);
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().add(contentPaneLayout.createSequentialGroup().add(34, 34, 34).add(contentPaneLayout.createParallelGroup(3).add(this.genomeComboBoxLabel).add(this.genomeComboBox, -2, 23, -2)).add(25, 25, 25).add(contentPaneLayout.createParallelGroup(3).add(this.okButton).add(this.cancelButton)).addContainerGap(130, Short.MAX_VALUE)));
        contentPaneLayout.linkSize(new Component[]{this.cancelButton, this.okButton}, 2);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = false;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GenomeSelectionDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

