/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.HashMap;
import java.util.Map;

public enum WindowFunction {
    none("None"),
    mean("Mean"),
    median("Median"),
    min("Minimum"),
    max("Maximum"),
    percentile2("2nd Percentile"),
    percentile10("10th Percentile"),
    percentile90("90th Percentile"),
    percentile98("98th Percentile"),
    stddev("Standard Deviation"),
    count("Count"),
    density("Density");

    static final Map<String, WindowFunction> wfMap;
    private String displayName = "";

    private WindowFunction(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static WindowFunction getWindowFunction(String name) {
        return wfMap.get(name);
    }

    static {
        wfMap = new HashMap<String, WindowFunction>();
        for (WindowFunction c : WindowFunction.values()) {
            wfMap.put(c.name(), c);
        }
    }
}

