/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.hic.Context;
import org.broad.igv.hic.HiCReferenceFrame;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.panel.ReferenceFrame;

public class HiCRenderContext
implements RenderContext {
    JComponent parent;
    Graphics2D graphics;
    Context context;
    Rectangle visibleRect;
    ReferenceFrame referenceFrame;
    private Map<Color, Graphics2D> graphicCacheByColor;

    public HiCRenderContext(Context context, JComponent panel, Graphics2D graphics, Rectangle visibleRect, Genome genome) {
        this.parent = panel;
        this.graphics = graphics;
        this.context = context;
        this.visibleRect = visibleRect;
        this.referenceFrame = new HiCReferenceFrame("HiC", genome);
        this.graphicCacheByColor = new HashMap<Color, Graphics2D>();
    }

    @Override
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    public String getChr() {
        return this.context.getChromosome().getName();
    }

    @Override
    public double getOrigin() {
        return this.context.getOrigin();
    }

    @Override
    public double getEndLocation() {
        return this.context.getChromosomePosition(500);
    }

    @Override
    public double getScale() {
        return this.context.getScale();
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    @Override
    public JComponent getPanel() {
        return this.parent;
    }

    @Override
    public Graphics2D getGraphics() {
        return this.graphics;
    }

    @Override
    public int getZoom() {
        return 0;
    }

    @Override
    public String getGenomeId() {
        return null;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public int bpToScreenPixel(double location) {
        return this.context.getScreenPosition(location);
    }

    @Override
    public Graphics2D getGraphic2DForColor(Color color) {
        Graphics2D g = this.graphicCacheByColor.get(color);
        if (g == null) {
            g = (Graphics2D)this.graphics.create();
            this.graphicCacheByColor.put(color, g);
            g.setColor(color);
        }
        return g;
    }

    @Override
    public void dispose() {
        for (Graphics2D g : this.graphicCacheByColor.values()) {
            g.dispose();
        }
        this.graphicCacheByColor.clear();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

