/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureCodecParser;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;

public abstract class AbstractFeatureParser
implements FeatureParser {
    private static Logger log = Logger.getLogger(IGV.class);
    protected int startBase = 0;
    boolean gffTags = false;
    protected TrackProperties trackProperties = null;

    public static boolean canParse(String path) {
        return AbstractFeatureParser.getCodec(path, null) != null;
    }

    public static FeatureParser getInstanceFor(ResourceLocator locator, Genome genome) {
        String path = locator.getPath();
        return AbstractFeatureParser.getInstanceFor(path, genome);
    }

    public static FeatureParser getInstanceFor(String path, Genome genome) {
        FeatureCodec codec = AbstractFeatureParser.getCodec(path, genome);
        if (codec != null) {
            return new FeatureCodecParser(codec, genome);
        }
        return null;
    }

    private static FeatureCodec getCodec(String path, Genome genome) {
        String tmp = AbstractFeatureParser.getStrippedFilename(path);
        return CodecFactory.getCodec(tmp, genome);
    }

    @Override
    public List<FeatureTrack> loadTracks(ResourceLocator locator, Genome genome) {
        List<Feature> features = this.loadFeatures(locator, -1);
        if (features.size() == 0) {
            // empty if block
        }
        return AbstractFeatureParser.loadTracks(features, locator, genome, this.trackProperties);
    }

    private List<FeatureTrack> loadTracks(List<Feature> features, ResourceLocator locator, Genome genome) {
        FeatureCollectionSource source = new FeatureCollectionSource(features, genome);
        FeatureTrack track = new FeatureTrack(locator, source);
        track.setName(locator.getTrackName());
        track.setRendererClass(IGVFeatureRenderer.class);
        track.setHeight(45);
        if (this.trackProperties != null) {
            track.setProperties(this.trackProperties);
        }
        ArrayList<FeatureTrack> tracks = new ArrayList<FeatureTrack>();
        tracks.add(track);
        return tracks;
    }

    public static List<FeatureTrack> loadTracks(Iterable<Feature> features, ResourceLocator locator, Genome genome, TrackProperties trackProperties) {
        FeatureCollectionSource source = new FeatureCollectionSource(features, genome);
        if (IGV.hasInstance() || Globals.isTesting()) {
            Set<String> chrs = source.getChrs();
            for (String chr : chrs) {
                List<Feature> feats = source.getFeatures(chr);
                for (Feature f : feats) {
                    if (!(f instanceof NamedFeature)) continue;
                    FeatureDB.addFeature((NamedFeature)f);
                }
            }
        }
        FeatureTrack track = new FeatureTrack(locator, source);
        track.setName(locator.getTrackName());
        track.setRendererClass(IGVFeatureRenderer.class);
        track.setHeight(45);
        if (trackProperties != null) {
            track.setProperties(trackProperties);
        }
        ArrayList<FeatureTrack> tracks = new ArrayList<FeatureTrack>();
        tracks.add(track);
        return tracks;
    }

    public List<Feature> loadFeatures(ResourceLocator locator, int maxLines) {
        BufferedReader reader = null;
        try {
            reader = ParsingUtils.openBufferedReader(locator);
            List<Feature> list = this.loadFeatures(reader, maxLines);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public List<Feature> loadFeatures(BufferedReader reader, Genome genome) {
        return this.loadFeatures(reader, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Feature> loadFeatures(BufferedReader reader, int maxLines) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String nextLine = null;
        int nLines = 0;
        try {
            while ((nextLine = reader.readLine()) != null) {
                if ((nextLine = nextLine.trim()).length() == 0) continue;
                if (maxLines <= 0 || ++nLines <= maxLines) {
                    try {
                        if (nextLine.startsWith("#")) {
                            String[] tokens;
                            if (nextLine.startsWith("#type")) {
                                tokens = Globals.equalPattern.split(nextLine);
                                if (tokens.length <= 1) continue;
                                try {
                                    TrackType type = TrackType.valueOf(tokens[1]);
                                }
                                catch (Exception e) {
                                    log.error("Error converting track type: " + tokens[1]);
                                }
                                continue;
                            }
                            if (nextLine.startsWith("#track")) {
                                TrackProperties tp = new TrackProperties();
                                ParsingUtils.parseTrackLine(nextLine, tp);
                                this.setTrackProperties(tp);
                                if (!tp.isGffTags()) continue;
                                this.gffTags = true;
                                continue;
                            }
                            if (nextLine.startsWith("#coords")) {
                                try {
                                    tokens = Globals.equalPattern.split(nextLine);
                                    this.startBase = Integer.parseInt(tokens[1]);
                                }
                                catch (Exception e) {
                                    log.error("Error parsing coords line: " + nextLine, e);
                                }
                                continue;
                            }
                            if (!nextLine.startsWith("#gffTags")) continue;
                            this.gffTags = true;
                            continue;
                        }
                        Feature feature = this.parseLine(nextLine);
                        if (feature == null) continue;
                        features.add(feature);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                break;
            }
        }
        catch (EOFException e) {
            return features;
        }
        catch (Exception e) {
            if (nextLine != null && nLines != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, nLines, nextLine);
            }
            throw new RuntimeException(e);
        }
        FeatureDB.addFeatures(features);
        return features;
    }

    protected abstract Feature parseLine(String var1);

    protected static String getStrippedFilename(String filename) {
        String tmp = filename.toLowerCase();
        if (filename.endsWith(".gz")) {
            tmp = tmp.substring(0, tmp.length() - 3);
        }
        if (tmp.endsWith(".tab") || tmp.endsWith(".txt") || tmp.endsWith(".csv")) {
            tmp = tmp.substring(0, tmp.length() - 4);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpFeatures(List<IGVFeature> features, String outputfile) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(outputfile));
            pw.println("Header row");
            for (IGVFeature gene : features) {
                pw.print(gene.getName() + "\t");
                pw.print(gene.getIdentifier() + "\t");
                pw.print(gene.getChr() + "\t");
                if (gene.getStrand() == Strand.POSITIVE) {
                    pw.print("+\t");
                } else if (gene.getStrand() == Strand.NEGATIVE) {
                    pw.print("-\t");
                } else {
                    pw.print(" \t");
                }
                pw.print(gene.getStart() + "\t");
                pw.print(gene.getEnd() + "\t");
                List<Exon> regions = gene.getExons();
                pw.print(regions.size() + "\t");
                for (Exon exon : regions) {
                    pw.print(exon.getStart() + ",");
                }
                pw.print("\t");
                for (Exon exon : regions) {
                    pw.print(exon.getEnd() + ",");
                }
                pw.println();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    protected void setTrackProperties(TrackProperties trackProperties) {
        this.trackProperties = trackProperties;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }
}

