/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import net.sf.samtools.util.SortingCollection;
import org.broad.igv.util.ParsingUtils;

public class AlignmentsSorter {
    public static void main(String[] args) throws IOException {
        String ifile = "/Users/jrobinso/projects/hi-c/test/data/selected_formatted.txt";
        String ofile = "/Users/jrobinso/projects/hi-c/test/data/selected_formatted.sorted.txt";
        File tmpdir = new File("/Users/jrobinso/tmp");
        AlignmentsSorter.sort(ifile, ofile, tmpdir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sort(String inputFile, String outputFile, File tmpdir) throws IOException {
        int maxRecordsInRam = 500000;
        Comparator<AlignmentRecord> comp = new Comparator<AlignmentRecord>(){

            @Override
            public int compare(AlignmentRecord rec1, AlignmentRecord rec2) {
                int c = rec1.chr1.compareTo(rec2.chr1);
                if (c != 0) {
                    return c;
                }
                return rec1.pos1 - rec2.pos1;
            }
        };
        SortingCollection<AlignmentRecord> cltn = SortingCollection.newInstance(AlignmentRecord.class, new Codec(), comp, maxRecordsInRam, tmpdir);
        BufferedReader br = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(inputFile);
            while ((nextLine = br.readLine()) != null) {
                try {
                    String[] tokens = nextLine.split("\\s+");
                    AlignmentRecord rec = new AlignmentRecord();
                    rec.line = nextLine;
                    rec.chr1 = tokens[1].trim();
                    rec.pos1 = Integer.parseInt(tokens[2]);
                    cltn.add(rec);
                }
                catch (Exception e) {
                    System.err.println("Skipping line: " + nextLine + "  " + e.getMessage());
                }
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        cltn.doneAdding();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            for (AlignmentRecord rec : cltn) {
                pw.println(rec.line);
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    static class Codec
    implements SortingCollection.Codec<AlignmentRecord> {
        PrintWriter os;
        BufferedReader is;

        Codec() {
        }

        @Override
        public void setOutputStream(OutputStream outputStream) {
            this.os = new PrintWriter(outputStream);
        }

        @Override
        public void setInputStream(InputStream inputStream) {
            this.is = new BufferedReader(new InputStreamReader(inputStream), 100);
        }

        @Override
        public void encode(AlignmentRecord rec) {
            this.os.println(rec.line);
            this.os.flush();
        }

        @Override
        public AlignmentRecord decode() {
            AlignmentRecord rec = new AlignmentRecord();
            try {
                rec.line = this.is.readLine();
                if (rec.line == null) {
                    return null;
                }
                String[] tokens = rec.line.split("\\s+");
                rec.chr1 = tokens[1].trim();
                rec.pos1 = Integer.parseInt(tokens[2]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return rec;
        }

        @Override
        public SortingCollection.Codec<AlignmentRecord> clone() {
            Codec clone = new Codec();
            clone.is = this.is;
            clone.os = this.os;
            return clone;
        }
    }

    static class AlignmentRecord {
        String chr1;
        int pos1;
        String line;

        AlignmentRecord() {
        }
    }
}

