/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CachingQueryReader;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;

public class AlignmentInterval
extends Locus {
    private static Logger log = Logger.getLogger(AlignmentInterval.class);
    Genome genome;
    private int maxCount = 0;
    private List<AlignmentCounts> counts;
    private LinkedHashMap<String, List<Row>> groupedAlignmentRows;
    private List<SpliceJunctionFeature> spliceJunctions;
    private List<CachingQueryReader.DownsampledInterval> downsampledIntervals;

    public AlignmentInterval(String chr, int start, int end, LinkedHashMap<String, List<Row>> groupedAlignmentRows, List<AlignmentCounts> counts, List<SpliceJunctionFeature> spliceJunctions, List<CachingQueryReader.DownsampledInterval> downsampledIntervals) {
        super(chr, start, end);
        this.groupedAlignmentRows = groupedAlignmentRows;
        this.genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        this.counts = counts;
        for (AlignmentCounts c : counts) {
            this.maxCount = Math.max(this.maxCount, c.getMaxCount());
        }
        this.spliceJunctions = spliceJunctions;
        this.downsampledIntervals = downsampledIntervals;
        boolean showSpliceJunctionTrack = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
        if (showSpliceJunctionTrack) {
            try {
                this.getSpliceJunctions();
            }
            catch (IOException e) {
                log.error("Error computing splice junctions", e);
            }
        }
    }

    static Alignment getFeatureContaining(List<Alignment> features, int right) {
        int leftBounds = 0;
        int rightBounds = features.size() - 1;
        int idx = features.size() / 2;
        int lastIdx = -1;
        while (idx != lastIdx) {
            lastIdx = idx;
            Alignment f = features.get(idx);
            if (f.contains(right)) {
                return f;
            }
            if (f.getStart() > right) {
                rightBounds = idx;
                idx = (leftBounds + idx) / 2;
                continue;
            }
            leftBounds = idx;
            idx = (rightBounds + idx) / 2;
        }
        if (features.get(0).contains(right)) {
            return features.get(0);
        }
        if (features.get(rightBounds).contains(right)) {
            return features.get(rightBounds);
        }
        return null;
    }

    public LinkedHashMap<String, List<Row>> getGroupedAlignments() {
        return this.groupedAlignmentRows;
    }

    public int getGroupCount() {
        return this.groupedAlignmentRows == null ? 0 : this.groupedAlignmentRows.size();
    }

    public void setAlignmentRows(LinkedHashMap<String, List<Row>> alignmentRows) {
        this.groupedAlignmentRows = alignmentRows;
    }

    public void sortRows(AlignmentTrack.SortOption option, ReferenceFrame referenceFrame, String tag) {
        double center = referenceFrame.getCenter();
        this.sortRows(option, center, tag);
    }

    public void sortRows(AlignmentTrack.SortOption option, double location, String tag) {
        if (this.groupedAlignmentRows == null) {
            return;
        }
        for (List<Row> alignmentRows : this.groupedAlignmentRows.values()) {
            for (Row row : alignmentRows) {
                row.updateScore(option, location, this, tag);
            }
            Collections.sort(alignmentRows, new Comparator<Row>(){

                @Override
                public int compare(Row arg0, Row arg1) {
                    if (arg0.getScore() > arg1.getScore()) {
                        return 1;
                    }
                    if (arg0.getScore() < arg1.getScore()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
    }

    public byte getReference(int pos) {
        if (this.genome == null) {
            return 0;
        }
        return this.genome.getReference(this.getChr(), pos);
    }

    public List<AlignmentCounts> getCounts() {
        return this.counts;
    }

    public int getCount(int pos, byte b) {
        for (AlignmentCounts c : this.counts) {
            if (pos < c.getStart() || pos >= c.getEnd()) continue;
            return c.getCount(pos, b);
        }
        return 0;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public AlignmentCounts getAlignmentCounts(int pos) {
        for (AlignmentCounts c : this.counts) {
            if (pos < c.getStart() || pos >= c.getEnd()) continue;
            return c;
        }
        return null;
    }

    public int getTotalCount(int pos) {
        for (AlignmentCounts c : this.counts) {
            if (pos < c.getStart() || pos >= c.getEnd()) continue;
            return c.getTotalCount(pos);
        }
        return 0;
    }

    public int getNegCount(int pos, byte b) {
        for (AlignmentCounts c : this.counts) {
            if (pos < c.getStart() || pos >= c.getEnd()) continue;
            return c.getNegCount(pos, b);
        }
        return 0;
    }

    public int getPosCount(int pos, byte b) {
        for (AlignmentCounts c : this.counts) {
            if (pos < c.getStart() || pos >= c.getEnd()) continue;
            return c.getPosCount(pos, b);
        }
        return 0;
    }

    public int getDelCount(int pos) {
        for (AlignmentCounts c : this.counts) {
            if (pos < c.getStart() || pos >= c.getEnd()) continue;
            return c.getDelCount(pos);
        }
        return 0;
    }

    public int getInsCount(int pos) {
        for (AlignmentCounts c : this.counts) {
            if (pos < c.getStart() || pos >= c.getEnd()) continue;
            return c.getInsCount(pos);
        }
        return 0;
    }

    public Iterator<Alignment> getAlignmentIterator() {
        return new AlignmentIterator();
    }

    public List<SpliceJunctionFeature> getSpliceJunctions() throws IOException {
        return this.spliceJunctions;
    }

    public List<CachingQueryReader.DownsampledInterval> getDownsampledIntervals() {
        return this.downsampledIntervals;
    }

    class AlignmentIterator
    implements Iterator<Alignment> {
        PriorityQueue<Row> rows;
        Alignment nextAlignment;

        AlignmentIterator() {
            this.rows = new PriorityQueue<Row>(5, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    return o1.getNextStartPos() - o2.getNextStartPos();
                }
            });
            for (List alignmentRows : AlignmentInterval.this.groupedAlignmentRows.values()) {
                for (Row r : alignmentRows) {
                    r.resetIdx();
                    this.rows.add(r);
                }
            }
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextAlignment != null;
        }

        @Override
        public Alignment next() {
            Alignment tmp = this.nextAlignment;
            if (tmp != null) {
                this.advance();
            }
            return tmp;
        }

        private void advance() {
            this.nextAlignment = null;
            Row nextRow = null;
            block0: while (this.nextAlignment == null && !this.rows.isEmpty()) {
                while ((nextRow = this.rows.poll()) != null) {
                    if (!nextRow.hasNext()) continue;
                    this.nextAlignment = nextRow.nextAlignment();
                    continue block0;
                }
            }
            if (nextRow != null && this.nextAlignment != null) {
                this.rows.add(nextRow);
            }
        }

        @Override
        public void remove() {
        }
    }

    public static class Row {
        int nextIdx = 0;
        private double score = 0.0;
        List<Alignment> alignments = new ArrayList<Alignment>(100);
        private int start;
        private int lastEnd;

        public void addAlignment(Alignment alignment) {
            if (this.alignments.isEmpty()) {
                this.start = alignment.getStart();
            }
            this.alignments.add(alignment);
            this.lastEnd = alignment.getEnd();
        }

        public void updateScore(AlignmentTrack.SortOption option, double center, AlignmentInterval interval, String tag) {
            int adjustedCenter = (int)center;
            Alignment centerAlignment = AlignmentInterval.getFeatureContaining(this.alignments, adjustedCenter);
            if (centerAlignment == null) {
                this.setScore(Double.MAX_VALUE);
            } else {
                switch (option) {
                    case START: {
                        this.setScore(centerAlignment.getStart());
                        break;
                    }
                    case STRAND: {
                        this.setScore(centerAlignment.isNegativeStrand() ? -1.0 : 1.0);
                        break;
                    }
                    case FIRST_OF_PAIR_STRAND: {
                        Strand strand = centerAlignment.getFirstOfPairStrand();
                        int score = 2;
                        if (strand != Strand.NONE) {
                            score = strand == Strand.NEGATIVE ? 1 : -1;
                        }
                        this.setScore(score);
                        break;
                    }
                    case NUCELOTIDE: {
                        byte base = centerAlignment.getBase(adjustedCenter);
                        byte ref = interval.getReference(adjustedCenter);
                        if (base == 0) {
                            this.setScore(2.147483647E9);
                            break;
                        }
                        if (base == 78 || base == 110) {
                            this.setScore(2.147483645E9);
                            break;
                        }
                        if (base == ref) {
                            this.setScore(2.147483646E9);
                            break;
                        }
                        int count = interval.getCount(adjustedCenter, base);
                        byte phred = centerAlignment.getPhred(adjustedCenter);
                        this.setScore(-((float)count + (float)phred / 100.0f));
                        break;
                    }
                    case QUALITY: {
                        this.setScore(-centerAlignment.getMappingQuality());
                        break;
                    }
                    case SAMPLE: {
                        String sample = centerAlignment.getSample();
                        int score = sample == null ? 0 : sample.hashCode();
                        this.setScore(score);
                        break;
                    }
                    case READ_GROUP: {
                        String readGroup = centerAlignment.getReadGroup();
                        int score = readGroup == null ? 0 : readGroup.hashCode();
                        this.setScore(score);
                        break;
                    }
                    case INSERT_SIZE: {
                        this.setScore(-Math.abs(centerAlignment.getInferredInsertSize()));
                        break;
                    }
                    case MATE_CHR: {
                        ReadMate mate = centerAlignment.getMate();
                        if (mate == null) {
                            this.setScore(2.147483647E9);
                            break;
                        }
                        if (mate.getChr().equals(centerAlignment.getChr())) {
                            this.setScore(2.147483646E9);
                            break;
                        }
                        this.setScore(mate.getChr().hashCode());
                        break;
                    }
                    case TAG: {
                        Object tagValue = centerAlignment.getAttribute(tag);
                        int score = tagValue == null ? 0 : tagValue.hashCode();
                        this.setScore(score);
                    }
                }
            }
        }

        public Alignment nextAlignment() {
            if (this.nextIdx < this.alignments.size()) {
                Alignment tmp = this.alignments.get(this.nextIdx);
                ++this.nextIdx;
                return tmp;
            }
            return null;
        }

        public int getNextStartPos() {
            if (this.nextIdx < this.alignments.size()) {
                return this.alignments.get(this.nextIdx).getStart();
            }
            return Integer.MAX_VALUE;
        }

        public boolean hasNext() {
            return this.nextIdx < this.alignments.size();
        }

        public void resetIdx() {
            this.nextIdx = 0;
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double score) {
            this.score = score;
        }

        public int getStart() {
            return this.start;
        }

        public int getLastEnd() {
            return this.lastEnd;
        }
    }
}

