/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.tools.sort.Parser;
import org.broad.igv.tools.sort.Sorter;
import org.broad.tribble.readers.AsciiLineReader;

public class GWASSorter
extends Sorter {
    static Logger log = Logger.getLogger(GWASSorter.class);
    private int chrCol = -1;
    private int startCol = -1;
    List<String> headerLines = new ArrayList<String>();

    public GWASSorter(File inputFile, File outputFile) {
        super(inputFile, outputFile);
        this.findColumns(inputFile);
    }

    private void findColumns(File inputFile) {
        BufferedReader br = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(inputFile));
            while ((nextLine = br.readLine()) != null) {
                this.headerLines.add(nextLine);
                if (nextLine.startsWith("#")) continue;
                String[] tokens = Globals.singleTabMultiSpacePattern.split(nextLine);
                for (int i = 0; i < tokens.length; ++i) {
                    if (tokens[i].equalsIgnoreCase("chr")) {
                        this.chrCol = i;
                        continue;
                    }
                    if (!tokens[i].equalsIgnoreCase("bp")) continue;
                    this.startCol = i;
                }
            }
            if (this.chrCol < 0) {
                throw new RuntimeException("Could not find chromosome column");
            }
            if (this.startCol < 0) {
                throw new RuntimeException("Could not find start column");
            }
        }
        catch (IOException e) {
            log.error("Error reading GWAS file", e);
            throw new RuntimeException("Error reading GWAS file" + e.getMessage(), e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    Parser getParser() {
        return new Parser(this.chrCol, this.startCol, true);
    }

    @Override
    String writeHeader(AsciiLineReader reader, PrintWriter writer) throws IOException {
        String nextLine;
        while ((nextLine = reader.readLine()) != null) {
            writer.println(nextLine);
            if (nextLine.startsWith("#")) continue;
            break;
        }
        return null;
    }
}

