/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.broad.igv.gs.GSFileBrowser;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;

public class GSOpenSessionMenuAction
extends MenuAction {
    private static Logger log = Logger.getLogger(GSOpenSessionMenuAction.class);
    private IGV mainFrame;
    private String sessionFile = null;
    private boolean autoload = false;

    public GSOpenSessionMenuAction(String label, IGV mainFrame) {
        super(label);
        this.mainFrame = mainFrame;
        this.setToolTipText("Reload the session");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            GSFileBrowser fileBrowser = new GSFileBrowser(IGV.getMainFrame(), GSFileBrowser.Mode.OPEN);
            fileBrowser.setVisible(true);
            this.sessionFile = fileBrowser.getFileURL();
            if (this.sessionFile == null || this.sessionFile.length() == 0) {
                return;
            }
            if (IGV.getInstance().getAllTracks(false).size() > 0) {
                GSOpenSessionMenuAction gSOpenSessionMenuAction = this;
                int status = JOptionPane.showConfirmDialog(gSOpenSessionMenuAction.mainFrame.getMainFrame(), "<html>Opening a session will unload all current data. <br>Are you sure you wish to continue?", null, 2, -1, null);
                if (status == 2 || status == -1) {
                    return;
                }
            }
            if (this.sessionFile != null) {
                SwingWorker worker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        boolean merge = false;
                        GSOpenSessionMenuAction.this.mainFrame.doRestoreSession(GSOpenSessionMenuAction.this.sessionFile, null, merge);
                        return null;
                    }
                };
                worker.execute();
            }
        }
        catch (Exception e1) {
            log.error("Error restoring session", e1);
            MessageUtils.confirm("Error loading session from GenomeSpace.  " + e1.toString());
        }
    }
}

