/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.panel.FrameManager;

public class History {
    private static Logger log = Logger.getLogger(History.class);
    int maxEntries = 100;
    int currPos = 0;
    LinkedList<Entry> activeStack;
    List<Entry> allHistory;

    public History(int maxEntries) {
        this.maxEntries = maxEntries;
        this.activeStack = new LinkedList();
        this.allHistory = new ArrayList<Entry>();
    }

    public void push(String s, int zoom) {
        if (s == null || s.length() == 0) {
            return;
        }
        if (FrameManager.isGeneListMode() && !s.startsWith("List")) {
            return;
        }
        if (this.activeStack.size() > 0 && s.equals(this.activeStack.peek().locus)) {
            return;
        }
        log.debug("History: " + s);
        this.allHistory.add(new Entry(s, zoom));
        while (this.currPos > 0) {
            this.activeStack.removeFirst();
            --this.currPos;
        }
        this.activeStack.addFirst(new Entry(s, zoom));
    }

    public void back() {
        if (this.canGoBack()) {
            ++this.currPos;
            Entry item = this.activeStack.get(this.currPos);
            this.processItem(item);
        }
    }

    public void forward() {
        if (this.canGoForward()) {
            --this.currPos;
            Entry item = this.activeStack.get(this.currPos);
            this.processItem(item);
        }
    }

    public boolean canGoBack() {
        return this.activeStack.size() > 0 && this.currPos < this.activeStack.size() - 1;
    }

    public boolean canGoForward() {
        return this.activeStack.size() > 0 && this.currPos > 0;
    }

    public void processItem(Entry entry) {
        if (entry != null) {
            String locus = entry.getLocus();
            if (locus.startsWith("List: ")) {
                String listName = locus.substring(6);
                IGV.getInstance().setGeneList(listName, false);
            } else {
                if (FrameManager.isGeneListMode()) {
                    IGV.getInstance().setGeneList(null, false);
                }
                new SearchCommand(FrameManager.getDefaultFrame(), locus, false).execute();
                FrameManager.getDefaultFrame().setZoom(entry.getZoom());
            }
        }
    }

    public Entry peekBack() {
        if (this.activeStack.size() == 0 || this.currPos + 1 >= this.activeStack.size()) {
            return null;
        }
        return this.activeStack.get(this.currPos + 1);
    }

    public Entry peekForward() {
        if (this.activeStack.size() == 0 || this.currPos - 1 < 0) {
            return null;
        }
        return this.activeStack.get(this.currPos - 1);
    }

    public void clear() {
        this.activeStack.clear();
        this.allHistory.clear();
        this.currPos = 0;
    }

    public void printStack() {
        System.out.println("curr pos=" + this.currPos);
        for (Entry s : this.activeStack) {
            System.out.println(s.getLocus());
        }
        System.out.println();
    }

    public List<Entry> getAllHistory() {
        return this.allHistory;
    }

    public static class Entry {
        private String locus;
        private int zoom;

        public Entry(String s, int zoom) {
            this.locus = s;
            this.zoom = zoom;
        }

        public String getLocus() {
            return this.locus;
        }

        public int getZoom() {
            return this.zoom;
        }

        public String toString() {
            return this.locus;
        }
    }
}

