/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.graph;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.graph.Graph;
import org.broad.igv.graph.Node;
import org.broad.igv.graph.SubGraph;
import org.broad.igv.ui.color.ColorUtilities;

public class GeneUtils {
    public static Graph getGraphFor(String gene, Genome genome) throws IOException {
        List<NamedFeature> nfList = FeatureDB.getFeaturesList(gene, 50);
        if (nfList != null) {
            return GeneUtils.createGraph(nfList);
        }
        return null;
    }

    private static Graph createGraph(List<NamedFeature> transcripts) {
        Graph graph = new Graph();
        HashSet<String> locusStrings = new HashSet<String>();
        ArrayList<Exon> uniqExons = new ArrayList<Exon>();
        for (NamedFeature nf : transcripts) {
            if (!(nf instanceof BasicFeature)) continue;
            BasicFeature t = (BasicFeature)nf;
            for (Exon exon : t.getExons()) {
                String locus = exon.getLocusString();
                if (locusStrings.contains(locus)) continue;
                uniqExons.add(exon);
                locusStrings.add(locus);
            }
        }
        Collections.sort(uniqExons, new Comparator<Exon>(){

            @Override
            public int compare(Exon exon1, Exon exon2) {
                return exon1.getStart() - exon2.getStart();
            }
        });
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        for (Exon exon : uniqExons) {
            String key = exon.getLocusString();
            nodes.put(key, new Node(exon.getStart()));
        }
        int idx = 1;
        for (NamedFeature nf : transcripts) {
            if (!(nf instanceof BasicFeature)) continue;
            BasicFeature t = (BasicFeature)nf;
            SubGraph sg = new SubGraph();
            Color color = ColorUtilities.randomColor(idx, 0.5f);
            List<Exon> exons = t.getExons();
            for (int i = 0; i < exons.size() - 1; ++i) {
                Node n1 = (Node)nodes.get(exons.get(i).getLocusString());
                Node n2 = (Node)nodes.get(exons.get(i + 1).getLocusString());
                sg.addEdge(n1, n2, color);
                graph.addNode(n1);
                graph.addNode(n2);
            }
            ++idx;
            graph.addSubGraph(sg);
        }
        graph.updateLayout();
        return graph;
    }
}

