/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.ScrollPaneOverview;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.plaf.UIResource;

public class CornerScroller
extends JideButton {
    protected ScrollPaneOverview _scrollPaneBidule;

    public CornerScroller(JScrollPane jScrollPane) {
        this._scrollPaneBidule = this.createScrollPaneOverview(jScrollPane);
        this.setFocusPainted(false);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CornerScroller.this._scrollPaneBidule.display();
            }
        });
        this.setBorderPainted(false);
        this.setIcon(new ScrollerIcon());
        this.setPreferredSize(new Dimension(16, 16));
    }

    protected ScrollPaneOverview createScrollPaneOverview(JScrollPane jScrollPane) {
        return new ScrollPaneOverview(jScrollPane, this);
    }

    public void setSelectionBorderColor(Color color) {
        if (this._scrollPaneBidule != null) {
            this._scrollPaneBidule.setSelectionBorderColor(color);
        }
    }

    private static class ScrollerIcon
    implements Icon,
    UIResource,
    Serializable {
        private ScrollerIcon() {
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath generalPath = new GeneralPath();
            int n3 = n + this.getIconWidth() / 2;
            int n4 = n2 + this.getIconHeight() / 2;
            int n5 = 4;
            generalPath.moveTo(n3 - n5, n4 - 2);
            generalPath.lineTo(n3 - n5 - 2, n4);
            generalPath.lineTo(n3 - n5, n4 + 2);
            generalPath.moveTo(n3 - 2, n4 - n5);
            generalPath.lineTo(n3, n4 - n5 - 2);
            generalPath.lineTo(n3 + 2, n4 - n5);
            generalPath.moveTo(n3 + n5, n4 - 2);
            generalPath.lineTo(n3 + n5 + 2, n4);
            generalPath.lineTo(n3 + n5, n4 + 2);
            generalPath.moveTo(n3 - 2, n4 + n5);
            generalPath.lineTo(n3, n4 + n5 + 2);
            generalPath.lineTo(n3 + 2, n4 + n5);
            graphics.setColor(Color.GRAY);
            graphics2D.draw(generalPath);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }
}

