/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.NumberFormatConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class BigDecimalConverter
extends NumberFormatConverter {
    public BigDecimalConverter() {
        super(new DecimalFormat("#,##0.00"));
    }

    public BigDecimalConverter(NumberFormat numberFormat) {
        super(numberFormat);
    }

    public Object fromString(String string, ConverterContext converterContext) {
        Object object = super.fromString(string, converterContext);
        if (object instanceof Double) {
            return new BigDecimal((Double)object);
        }
        if (object instanceof Long) {
            return new BigDecimal((Long)object);
        }
        if (object instanceof Integer) {
            return new BigDecimal((Integer)object);
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        return object;
    }

    public String toString(Object object, ConverterContext converterContext) {
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.doubleValue() == Double.NaN) {
                return "";
            }
            return super.toString(bigDecimal, converterContext);
        }
        return "";
    }
}

