/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

public class TribbleException
extends RuntimeException {
    String source;

    public TribbleException(String msg) {
        super(msg);
    }

    public TribbleException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getMessage() {
        String ret = super.getMessage();
        if (this.source != null) {
            ret = ret + ", for input source: " + this.source;
        }
        return ret;
    }

    public static class TabixReaderFailure
    extends TribbleException {
        public TabixReaderFailure(String message, String f, Exception e) {
            super(message, e);
            this.setSource(f);
        }

        public TabixReaderFailure(String message, String f) {
            super(message);
            this.setSource(f);
        }
    }

    public static class UnableToReadIndexFile
    extends TribbleException {
        public UnableToReadIndexFile(String message, String f, Exception e) {
            super(message, e);
            this.setSource(f);
        }
    }

    public static class MalformedFeatureFile
    extends TribbleException {
        public MalformedFeatureFile(String message, String f, Exception e) {
            super(message, e);
            this.setSource(f);
        }

        public MalformedFeatureFile(String message, String f) {
            super(message);
            this.setSource(f);
        }
    }

    public static class FeatureFileDoesntExist
    extends TribbleException {
        public FeatureFileDoesntExist(String message, String file) {
            super(message);
            this.setSource(file);
        }
    }

    public static class UnableToCreateCorrectIndexType
    extends TribbleException {
        public UnableToCreateCorrectIndexType(String message, Exception e) {
            super(message, e);
        }

        public UnableToCreateCorrectIndexType(String message) {
            super(message);
        }
    }

    public static class InternalCodecException
    extends TribbleException {
        public InternalCodecException(String message) {
            super(message);
        }
    }

    public static class InvalidHeader
    extends TribbleException {
        public InvalidHeader(String message) {
            super("Your input file has a malformed header: " + message);
        }
    }

    public static class InvalidDecodeLine
    extends TribbleException {
        public InvalidDecodeLine(String message, String line) {
            super(message + ", line = " + line);
        }

        public InvalidDecodeLine(String message, int lineNo) {
            super(message + ", at line number " + lineNo);
        }
    }
}

