/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.compression;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import edu.cornell.med.icb.goby.compression.ChunkCodec;
import edu.cornell.med.icb.goby.compression.ProtobuffCollectionHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class BZip2ChunkCodec
implements ChunkCodec {
    private ProtobuffCollectionHandler parser;
    public static final byte REGISTRATION_CODE = -3;

    @Override
    public void setHandler(ProtobuffCollectionHandler parser) {
        this.parser = parser;
    }

    @Override
    public String name() {
        return "bzip2";
    }

    @Override
    public byte registrationCode() {
        return -3;
    }

    @Override
    public ByteArrayOutputStream encode(Message readCollection) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(10000);
        CBZip2OutputStream bZip2OutputStream = new CBZip2OutputStream(byteBuffer);
        readCollection.writeTo(bZip2OutputStream);
        ((OutputStream)bZip2OutputStream).flush();
        ((OutputStream)bZip2OutputStream).close();
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message decode(byte[] bytes) throws IOException {
        CBZip2InputStream uncompressStream = new CBZip2InputStream(new ByteArrayInputStream(bytes));
        try {
            GeneratedMessage generatedMessage = this.parser.parse(uncompressStream);
            return generatedMessage;
        }
        finally {
            uncompressStream.close();
        }
    }

    @Override
    public int getSuggestedChunkSize() {
        return 20000;
    }
}

