/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import org.broad.igv.renderer.ColorScale;

public class ObservedColorScale
implements ColorScale {
    private int colorTableSize = 100;
    Color[] colorCache = new Color[this.colorTableSize];
    private int minCount = 0;
    private int maxCount = 200;
    private Color background;
    private float[] backgroundColorComponents;

    @Override
    public Color getColor(float score) {
        if (score < (float)this.minCount) {
            return this.background;
        }
        float v = score / (float)this.maxCount;
        float alpha = v < 0.05f ? 0.05f : (v > 1.0f ? 1.0f : v);
        int idx = (int)((float)(this.colorTableSize - 1) * alpha);
        Color c = this.colorCache[idx];
        if (c == null) {
            float rAlpha = Math.max(0.05f, Math.min(1.0f, 0.01f * (float)idx));
            float red = (1.0f - rAlpha) * this.backgroundColorComponents[0] + rAlpha;
            float green = (1.0f - rAlpha) * this.backgroundColorComponents[1];
            float blue = (1.0f - rAlpha) * this.backgroundColorComponents[2];
            this.colorCache[idx] = c = new Color(red, green, blue);
        }
        return c;
    }

    @Override
    public Color getColor(String symbol) {
        return null;
    }

    @Override
    public Color getNoDataColor() {
        return null;
    }

    @Override
    public String asString() {
        return null;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setBackground(Color background) {
        this.background = background;
        this.backgroundColorComponents = background.getColorComponents(null);
    }

    public void setRange(int min, int max) {
        this.minCount = min;
        this.maxCount = max;
    }
}

