/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.util.ArrayList;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;

public class FrameManager {
    private static List<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
    private static ReferenceFrame defaultFrame;

    public static ReferenceFrame getDefaultFrame() {
        if (defaultFrame == null) {
            defaultFrame = new ReferenceFrame("genome");
        }
        return defaultFrame;
    }

    public static List<ReferenceFrame> getFrames() {
        return frames;
    }

    public static void setFrames(List<ReferenceFrame> f) {
        frames = f;
    }

    public static boolean isGeneListMode() {
        return frames.size() > 1;
    }

    public static void setToDefaultFrame(String searchString) {
        Locus locus;
        frames.clear();
        if (searchString != null && (locus = FrameManager.getLocus(searchString, 0)) != null) {
            FrameManager.getDefaultFrame().setInterval(locus);
        }
        frames.add(FrameManager.getDefaultFrame());
        FrameManager.getDefaultFrame().recordHistory();
    }

    public static void resetFrames(GeneList gl) {
        frames.clear();
        if (gl == null) {
            frames.add(FrameManager.getDefaultFrame());
        } else {
            int flankingRegion = PreferenceManager.getInstance().getAsInt("FLAKING_REGIONS");
            ArrayList<String> lociNotFound = new ArrayList<String>();
            List<String> loci = gl.getLoci();
            if (loci.size() == 1) {
                Locus locus = FrameManager.getLocus(loci.get(0), flankingRegion);
                if (locus == null) {
                    lociNotFound.add(loci.get(0));
                } else {
                    IGV.getInstance().getSession().setCurrentGeneList(null);
                    FrameManager.getDefaultFrame().jumpTo(locus.getChr(), locus.getStart(), locus.getEnd());
                }
            } else {
                for (String searchString : gl.getLoci()) {
                    Locus locus = FrameManager.getLocus(searchString, flankingRegion);
                    if (locus == null) {
                        lociNotFound.add(searchString);
                        continue;
                    }
                    ReferenceFrame referenceFrame = new ReferenceFrame(searchString);
                    referenceFrame.setInterval(locus);
                    frames.add(referenceFrame);
                }
            }
            if (lociNotFound.size() > 1) {
                StringBuffer message = new StringBuffer();
                message.append("<html>The following loci could not be found in the currently loaded annotation sets: <br>");
                for (String s : lociNotFound) {
                    message.append(s + " ");
                }
                MessageUtils.showMessage(message.toString());
            }
        }
    }

    public static double getMinimumScale() {
        double minScale = Double.MAX_VALUE;
        for (ReferenceFrame frame : frames) {
            minScale = Math.min(minScale, frame.getScale());
        }
        return minScale;
    }

    public static Locus getLocus(String name) {
        int flankingRegion = PreferenceManager.getInstance().getAsInt("FLAKING_REGIONS");
        return FrameManager.getLocus(name, flankingRegion);
    }

    public static Locus getLocusNew(String searchString, int flankingRegion) {
        SearchCommand cmd = new SearchCommand(FrameManager.getDefaultFrame(), searchString);
        List<SearchCommand.SearchResult> results = cmd.runSearch(searchString);
        Locus locus = null;
        for (SearchCommand.SearchResult result : results) {
            if (result.getType() == SearchCommand.ResultType.ERROR) continue;
            locus = new Locus(result.getChr(), result.getStart() - flankingRegion, result.getEnd() + flankingRegion);
            break;
        }
        return locus;
    }

    public static Locus getLocus(String searchString, int flankingRegion) {
        Locus locus = null;
        NamedFeature feature = FeatureDB.getFeature(searchString.toUpperCase().trim());
        if (feature != null) {
            locus = new Locus(feature.getChr(), feature.getStart() - flankingRegion, feature.getEnd() + flankingRegion);
        } else {
            Chromosome chromsome;
            Genome genome;
            locus = new Locus(searchString);
            String chr = locus.getChr();
            if (chr != null) {
                return locus;
            }
            locus = null;
            if (IGV.hasInstance() && (genome = IGV.getInstance().getGenomeManager().getCurrentGenome()) != null && (chromsome = genome.getChromosome(searchString)) != null) {
                locus = new Locus(chromsome.getName(), 0, chromsome.getLength());
            }
        }
        return locus;
    }

    public static void removeFrame(ReferenceFrame frame) {
        frames.remove(frame);
    }

    public static void reset(String chr) {
        FrameManager.setToDefaultFrame(null);
        FrameManager.getDefaultFrame().setChrName(chr);
        FrameManager.getDefaultFrame().computeMaxZoom();
        FrameManager.getDefaultFrame().invalidateLocationScale();
    }

    static {
        if (!Globals.isHeadless()) {
            frames.add(FrameManager.getDefaultFrame());
        }
    }
}

