/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.SamAlignment;

class SAMQueryIterator
implements CloseableIterator<Alignment> {
    String chr;
    int start;
    int end;
    boolean contained;
    SAMRecord currentRecord;
    CloseableIterator<SAMRecord> wrappedIterator;

    public SAMQueryIterator(CloseableIterator<SAMRecord> wrappedIterator) {
        this.chr = null;
        this.wrappedIterator = wrappedIterator;
        this.currentRecord = (SAMRecord)wrappedIterator.next();
    }

    public SAMQueryIterator(String sequence, int start, int end, boolean contained, CloseableIterator<SAMRecord> wrappedIterator) {
        this.chr = sequence;
        this.start = start;
        this.end = end;
        this.contained = contained;
        this.wrappedIterator = wrappedIterator;
        this.advanceToFirstRecord();
    }

    private void advanceToFirstRecord() {
        while (this.wrappedIterator.hasNext()) {
            this.currentRecord = (SAMRecord)this.wrappedIterator.next();
            if (this.currentRecord.getReferenceName().equals(this.chr) && (!this.contained || this.currentRecord.getAlignmentStart() - 1 < this.start) && (this.contained || this.currentRecord.getAlignmentEnd() - 1 < this.start)) continue;
            break;
        }
    }

    @Override
    public void close() {
        this.wrappedIterator.close();
    }

    @Override
    public boolean hasNext() {
        if (this.chr == null && this.currentRecord != null) {
            return true;
        }
        if (this.currentRecord == null || this.chr != null && !this.chr.equals(this.currentRecord.getReferenceName())) {
            return false;
        }
        return this.contained ? this.currentRecord.getAlignmentEnd() <= this.end : this.currentRecord.getAlignmentStart() <= this.end;
    }

    @Override
    public SamAlignment next() {
        SAMRecord ret = this.currentRecord;
        this.currentRecord = this.wrappedIterator.hasNext() ? (SAMRecord)this.wrappedIterator.next() : null;
        return new SamAlignment(ret);
    }

    @Override
    public void remove() {
    }
}

