/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.PairedAlignment;

public class AlignmentPacker {
    private static Logger log = Logger.getLogger(AlignmentPacker.class);
    public static final int MIN_ALIGNMENT_SPACING = 5;
    private Comparator lengthComparator = new Comparator<Alignment>(){

        @Override
        public int compare(Alignment row1, Alignment row2) {
            return row2.getEnd() - row2.getStart() - (row1.getEnd() - row2.getStart());
        }
    };

    public LinkedHashMap<String, List<AlignmentInterval.Row>> packAlignments(Iterator<Alignment> iter, int end, boolean pairAlignments, AlignmentTrack.RenderOptions renderOptions) {
        LinkedHashMap<String, List<AlignmentInterval.Row>> packedAlignments = new LinkedHashMap<String, List<AlignmentInterval.Row>>();
        if (iter == null || !iter.hasNext()) {
            return packedAlignments;
        }
        AlignmentTrack.GroupOption groupBy = renderOptions.groupByOption;
        String tag = renderOptions.getGroupByTag();
        if (groupBy == null) {
            ArrayList<AlignmentInterval.Row> alignmentRows = new ArrayList<AlignmentInterval.Row>(10000);
            this.pack(iter, end, pairAlignments, this.lengthComparator, alignmentRows);
            packedAlignments.put("", alignmentRows);
        } else {
            ArrayList<Alignment> nullGroup = new ArrayList<Alignment>();
            HashMap<String, ArrayList<Alignment>> groupedAlignments = new HashMap<String, ArrayList<Alignment>>();
            while (iter.hasNext()) {
                Alignment alignment = iter.next();
                String groupKey = this.getGroupValue(alignment, groupBy, tag);
                if (groupKey == null) {
                    nullGroup.add(alignment);
                    continue;
                }
                ArrayList<Alignment> group = (ArrayList<Alignment>)groupedAlignments.get(groupKey);
                if (group == null) {
                    group = new ArrayList<Alignment>(1000);
                    groupedAlignments.put(groupKey, group);
                }
                group.add(alignment);
            }
            ArrayList keys = new ArrayList(groupedAlignments.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                ArrayList<AlignmentInterval.Row> alignmentRows = new ArrayList<AlignmentInterval.Row>(10000);
                List group = (List)groupedAlignments.get(key);
                this.pack(group.iterator(), end, pairAlignments, this.lengthComparator, alignmentRows);
                packedAlignments.put(key, alignmentRows);
            }
            ArrayList<AlignmentInterval.Row> alignmentRows = new ArrayList<AlignmentInterval.Row>(10000);
            this.pack(nullGroup.iterator(), end, pairAlignments, this.lengthComparator, alignmentRows);
            packedAlignments.put("", alignmentRows);
        }
        return packedAlignments;
    }

    private String getGroupValue(Alignment al, AlignmentTrack.GroupOption groupBy, String tag) {
        switch (groupBy) {
            case STRAND: {
                return String.valueOf(al.isNegativeStrand());
            }
            case SAMPLE: {
                return al.getSample();
            }
            case READ_GROUP: {
                return al.getReadGroup();
            }
            case TAG: {
                Object tagValue = al.getAttribute(tag);
                return tagValue == null ? null : tagValue.toString();
            }
            case FIRST_OF_PAIR_STRAND: {
                Strand strand = al.getFirstOfPairStrand();
                String strandString = strand == Strand.NONE ? null : strand.toString();
                return strandString;
            }
        }
        return null;
    }

    private void pack(Iterator<Alignment> iter, int end, boolean pairAlignments, Comparator lengthComparator, List<AlignmentInterval.Row> alignmentRows) {
        if (!iter.hasNext()) {
            return;
        }
        HashMap<String, PairedAlignment> pairs = null;
        if (pairAlignments) {
            pairs = new HashMap<String, PairedAlignment>(1000);
        }
        Alignment firstAlignment = iter.next();
        if (pairAlignments && firstAlignment.isPaired() && firstAlignment.isProperPair() && firstAlignment.getMate().isMapped()) {
            String readName = firstAlignment.getReadName();
            PairedAlignment pair = new PairedAlignment(firstAlignment);
            pairs.put(readName, pair);
            firstAlignment = pair;
        }
        int start = firstAlignment.getStart();
        int bucketCount = end - start + 1;
        PriorityQueue<Alignment> firstBucket = new PriorityQueue<Alignment>(5, lengthComparator);
        firstBucket.add(firstAlignment);
        BucketCollection buckets = bucketCount < 1000000 ? new DenseBucketCollection(bucketCount) : new SparseBucketCollection();
        buckets.set(0, firstBucket);
        int totalCount = 1;
        while (iter.hasNext()) {
            int bucketNumber;
            Alignment al = iter.next();
            String readName = al.getReadName();
            if (!al.isMapped()) continue;
            Alignment alignment = al;
            if (pairAlignments && al.isPaired() && al.getMate().isMapped() && al.getChr().equals(al.getMate().getChr())) {
                PairedAlignment pair = (PairedAlignment)pairs.get(readName);
                if (pair == null) {
                    pair = new PairedAlignment(al);
                    pairs.put(readName, pair);
                    alignment = pair;
                } else if (al.getChr().equals(pair.getChr())) {
                    pair.setSecondAlignment(al);
                    pairs.remove(readName);
                    continue;
                }
            }
            if ((bucketNumber = Math.max(0, alignment.getStart() - start)) < bucketCount) {
                PriorityQueue<Alignment> bucket = buckets.get(bucketNumber);
                if (bucket == null) {
                    bucket = new PriorityQueue(5, lengthComparator);
                    buckets.set(bucketNumber, bucket);
                }
                bucket.add(alignment);
                ++totalCount;
                continue;
            }
            log.debug("Alignment out of bounds: " + alignment.getStart() + " (> " + end);
        }
        buckets.finishedAdding();
        long t0 = System.currentTimeMillis();
        int allocatedCount = 0;
        int nextStart = start;
        AlignmentInterval.Row currentRow = new AlignmentInterval.Row();
        ArrayList<Integer> emptyBuckets = new ArrayList<Integer>(100);
        while (allocatedCount < totalCount) {
            int bucketNumber;
            PriorityQueue<Alignment> bucket;
            while (nextStart <= end && (bucket = buckets.getNextBucket(bucketNumber = nextStart - start, emptyBuckets)) != null) {
                Alignment alignment = (Alignment)bucket.remove();
                currentRow.addAlignment(alignment);
                nextStart = currentRow.getLastEnd() + 5;
                ++allocatedCount;
            }
            if (currentRow.alignments.size() > 0) {
                alignmentRows.add(currentRow);
            }
            buckets.removeBuckets(emptyBuckets);
            emptyBuckets.clear();
            currentRow = new AlignmentInterval.Row();
            nextStart = start;
        }
        if (log.isDebugEnabled()) {
            long dt = System.currentTimeMillis() - t0;
            log.debug("Packed alignments in " + dt);
        }
        if (currentRow != null && currentRow.alignments.size() > 0) {
            alignmentRows.add(currentRow);
        }
    }

    static class SparseBucketCollection
    implements BucketCollection {
        boolean finished = false;
        List<Integer> keys;
        HashMap<Integer, PriorityQueue<Alignment>> buckets = new HashMap(1000);

        SparseBucketCollection() {
        }

        @Override
        public void set(int idx, PriorityQueue<Alignment> bucket) {
            if (this.finished) {
                log.error("Error: bucket added after finishAdding() called");
            }
            this.buckets.put(idx, bucket);
        }

        @Override
        public PriorityQueue<Alignment> get(int idx) {
            return this.buckets.get(idx);
        }

        @Override
        public PriorityQueue<Alignment> getNextBucket(int bucketNumber, Collection<Integer> emptyBuckets) {
            Integer key;
            PriorityQueue<Alignment> bucket = null;
            int min = 0;
            int max = this.keys.size() - 1;
            while (max - min > 5) {
                int mid = (max + min) / 2;
                key = this.keys.get(mid);
                if (key > bucketNumber) {
                    max = mid;
                    continue;
                }
                min = mid;
            }
            for (int i = min; i < this.keys.size(); ++i) {
                key = this.keys.get(i);
                if (key < bucketNumber) continue;
                bucket = this.buckets.get(key);
                if (bucket.isEmpty()) {
                    emptyBuckets.add(key);
                    bucket = null;
                    continue;
                }
                return bucket;
            }
            return null;
        }

        @Override
        public void removeBuckets(Collection<Integer> emptyBuckets) {
            if (emptyBuckets.isEmpty()) {
                return;
            }
            for (Integer i : emptyBuckets) {
                this.buckets.remove(i);
            }
            this.keys = new ArrayList<Integer>(this.buckets.keySet());
            Collections.sort(this.keys);
        }

        @Override
        public void finishedAdding() {
            this.finished = true;
            this.keys = new ArrayList<Integer>(this.buckets.keySet());
            Collections.sort(this.keys);
        }
    }

    static class DenseBucketCollection
    implements BucketCollection {
        int lastBucketNumber = -1;
        PriorityQueue<Alignment>[] bucketArray;

        DenseBucketCollection(int bucketCount) {
            this.bucketArray = new PriorityQueue[bucketCount];
        }

        @Override
        public void set(int idx, PriorityQueue<Alignment> bucket) {
            this.bucketArray[idx] = bucket;
        }

        @Override
        public PriorityQueue<Alignment> get(int idx) {
            return this.bucketArray[idx];
        }

        @Override
        public PriorityQueue<Alignment> getNextBucket(int bucketNumber, Collection<Integer> emptyBuckets) {
            if (bucketNumber == this.lastBucketNumber) {
                // empty if block
            }
            PriorityQueue<Alignment> bucket = null;
            while (bucketNumber < this.bucketArray.length) {
                bucket = this.bucketArray[bucketNumber];
                if (bucket != null) {
                    if (bucket.isEmpty()) {
                        this.bucketArray[bucketNumber] = null;
                        bucket = null;
                    } else {
                        return bucket;
                    }
                }
                ++bucketNumber;
            }
            return null;
        }

        @Override
        public void removeBuckets(Collection<Integer> emptyBuckets) {
        }

        @Override
        public void finishedAdding() {
        }
    }

    static interface BucketCollection {
        public void set(int var1, PriorityQueue<Alignment> var2);

        public PriorityQueue<Alignment> get(int var1);

        public PriorityQueue<Alignment> getNextBucket(int var1, Collection<Integer> var2);

        public void removeBuckets(Collection<Integer> var1);

        public void finishedAdding();
    }
}

