/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.tribble.Feature;

public class PSLCodec
extends UCSCCodec {
    Genome genome;

    public PSLCodec() {
    }

    public PSLCodec(Genome genome) {
        this.genome = genome;
    }

    public Feature decode(String line) {
        BasicFeature f = null;
        try {
            if (line.trim().length() == 0 || line.startsWith("#") || line.startsWith("track") || line.startsWith("browser")) {
                return null;
            }
            String[] tokens = Globals.singleTabMultiSpacePattern.split(line);
            int nTokens = tokens.length;
            if (nTokens < 21) {
                return null;
            }
            int tSize = Integer.parseInt(tokens[14]);
            String chrToken = tokens[13];
            String chr = this.genome == null ? chrToken : this.genome.getChromosomeAlias(chrToken);
            int start = Integer.parseInt(tokens[15]);
            String strandString = tokens[8];
            Strand strand = strandString.startsWith("+") ? Strand.POSITIVE : Strand.NEGATIVE;
            boolean gNeg = false;
            if (strandString.length() > 1) {
                gNeg = strandString.charAt(1) == '-';
            }
            f = new BasicFeature();
            f.setName(tokens[9]);
            f.setChr(chr);
            f.setStart(start);
            f.setEnd(Integer.parseInt(tokens[16]));
            f.setStrand(strand);
            int exonCount = Integer.parseInt(tokens[17]);
            String[] exonSizes = tokens[18].split(",");
            String[] startsBuffer = tokens[20].split(",");
            if (startsBuffer.length == exonSizes.length && exonCount == startsBuffer.length) {
                for (int i = 0; i < startsBuffer.length; ++i) {
                    int exonSize = Integer.parseInt(exonSizes[i]);
                    int exonStart = Integer.parseInt(startsBuffer[i]);
                    if (gNeg) {
                        exonStart = tSize - exonStart - exonSize;
                    }
                    int exonEnd = exonStart + exonSize;
                    Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                    f.addExon(exon);
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return f;
    }

    @Override
    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".psl");
    }
}

