/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.Collection;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IExon;
import org.broad.igv.feature.IGVFeature;
import org.jgrapht.graph.DefaultDirectedGraph;

public class AlternativeSpliceGraph
extends DefaultDirectedGraph<IExon, Object> {
    private IExon lastExon = null;

    public AlternativeSpliceGraph() {
        super(Object.class);
    }

    public AlternativeSpliceGraph(Collection<? extends IGVFeature> features) {
        this();
        this.addFeatures(features);
    }

    public boolean addExon(IExon exon) {
        IExon eProx = Exon.getExonProxy(exon);
        boolean added = this.addVertex(eProx);
        if (added) {
            if (this.lastExon != null) {
                this.addEdge(this.lastExon, eProx);
            }
            this.lastExon = eProx;
        }
        return added;
    }

    private void addFeature(IGVFeature feature) {
        this.startFeature();
        for (Exon exon : feature.getExons()) {
            this.addExon(exon);
        }
    }

    private void addFeatures(Collection<? extends IGVFeature> features) {
        for (IGVFeature iGVFeature : features) {
            this.addFeature(iGVFeature);
        }
    }

    public void startFeature() {
        this.lastExon = null;
    }
}

