/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.ArrayList;
import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.SimpleAnimation;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGAnimationElementBridge;
import org.apache.batik.dom.anim.AnimatableElement;
import org.apache.batik.dom.anim.AnimationTarget;
import org.w3c.dom.Element;

public class SVGAnimateElementBridge
extends SVGAnimationElementBridge {
    public String getLocalName() {
        return "animate";
    }

    public Bridge getInstance() {
        return new SVGAnimateElementBridge();
    }

    protected AbstractAnimation createAnimation(AnimationTarget target) {
        AnimatableValue from = this.parseAnimatableValue("from");
        AnimatableValue to = this.parseAnimatableValue("to");
        AnimatableValue by = this.parseAnimatableValue("by");
        return new SimpleAnimation(this.timedElement, (AnimatableElement)this, this.parseCalcMode(), this.parseKeyTimes(), this.parseKeySplines(), this.parseAdditive(), this.parseAccumulate(), this.parseValues(), from, to, by);
    }

    protected int parseCalcMode() {
        if (this.animationType == 1 && !this.targetElement.isPropertyAdditive(this.attributeLocalName) || this.animationType == 0 && !this.targetElement.isAttributeAdditive(this.attributeNamespaceURI, this.attributeLocalName)) {
            return 0;
        }
        String calcModeString = this.element.getAttributeNS(null, "calcMode");
        if (calcModeString.length() == 0) {
            return this.getDefaultCalcMode();
        }
        if (calcModeString.equals("linear")) {
            return 1;
        }
        if (calcModeString.equals("discrete")) {
            return 0;
        }
        if (calcModeString.equals("paced")) {
            return 2;
        }
        if (calcModeString.equals("spline")) {
            return 3;
        }
        throw new BridgeException(this.ctx, (Element)this.element, "attribute.malformed", new Object[]{"calcMode", calcModeString});
    }

    protected boolean parseAdditive() {
        String additiveString = this.element.getAttributeNS(null, "additive");
        if (additiveString.length() == 0 || additiveString.equals("replace")) {
            return false;
        }
        if (additiveString.equals("sum")) {
            return true;
        }
        throw new BridgeException(this.ctx, (Element)this.element, "attribute.malformed", new Object[]{"additive", additiveString});
    }

    protected boolean parseAccumulate() {
        String accumulateString = this.element.getAttributeNS(null, "accumulate");
        if (accumulateString.length() == 0 || accumulateString.equals("none")) {
            return false;
        }
        if (accumulateString.equals("sum")) {
            return true;
        }
        throw new BridgeException(this.ctx, (Element)this.element, "attribute.malformed", new Object[]{"accumulate", accumulateString});
    }

    /*
     * Unable to fully structure code
     */
    protected AnimatableValue[] parseValues() {
        isCSS = this.animationType == 1;
        valuesString = this.element.getAttributeNS(null, "values");
        len = valuesString.length();
        if (len == 0) {
            return null;
        }
        values = new ArrayList<AnimatableValue>(7);
        i = 0;
        start = 0;
        ** GOTO lbl23
        while (++i != len) {
            while (valuesString.charAt(i) != ' ') {
                start = i++;
                if (i != len) {
                    c = valuesString.charAt(i);
                    while (c != ';') {
                        if (++i == len) break;
                        c = valuesString.charAt(i);
                    }
                }
                if (!this.checkValueType(val = this.eng.parseAnimatableValue((Element)this.element, this.animationTarget, this.attributeNamespaceURI, this.attributeLocalName, isCSS, valuesString.substring(start, end = i++)))) {
                    throw new BridgeException(this.ctx, (Element)this.element, "attribute.malformed", new Object[]{"values", valuesString});
                }
                values.add(val);
lbl23:
                // 2 sources

                if (i < len) continue;
            }
        }
        ret = new AnimatableValue[values.size()];
        return values.toArray(ret);
    }

    /*
     * Unable to fully structure code
     */
    protected float[] parseKeyTimes() {
        keyTimesString = this.element.getAttributeNS(null, "keyTimes");
        len = keyTimesString.length();
        if (len == 0) {
            return null;
        }
        keyTimes = new ArrayList<Float>(7);
        i = 0;
        start = 0;
        ** GOTO lbl26
        while (++i != len) {
            while (keyTimesString.charAt(i) != ' ') {
                start = i++;
                if (i != len) {
                    c = keyTimesString.charAt(i);
                    while (c != ' ' && c != ';') {
                        if (++i == len) break;
                        c = keyTimesString.charAt(i);
                    }
                }
                end = i++;
                try {
                    keyTime = Float.parseFloat(keyTimesString.substring(start, end));
                    keyTimes.add(new Float(keyTime));
                }
                catch (NumberFormatException nfEx) {
                    throw new BridgeException(this.ctx, (Element)this.element, nfEx, "attribute.malformed", new Object[]{"keyTimes", keyTimesString});
                }
lbl26:
                // 2 sources

                if (i < len) continue;
            }
        }
        len = keyTimes.size();
        ret = new float[len];
        j = 0;
        while (j < len) {
            ret[j] = ((Float)keyTimes.get(j)).floatValue();
            ++j;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    protected float[] parseKeySplines() {
        keySplinesString = this.element.getAttributeNS(null, "keySplines");
        len = keySplinesString.length();
        if (len == 0) {
            return null;
        }
        keySplines = new ArrayList<Float>(7);
        count = 0;
        i = 0;
        start = 0;
        ** GOTO lbl42
        while (++i != len) {
            while (keySplinesString.charAt(i) != ' ') {
                block13: {
                    block12: {
                        start = i++;
                        if (i == len) break block12;
                        c = keySplinesString.charAt(i);
                        while (c != ' ' && c != ',' && c != ';') {
                            if (++i == len) break;
                            c = keySplinesString.charAt(i);
                        }
                        end = i++;
                        if (c == ' ') {
                            while (i != len && (c = keySplinesString.charAt(i++)) == ' ') {
                            }
                            if (c != ';' && c != ',') {
                                --i;
                            }
                        }
                        if (c != ';') ** GOTO lbl30
                        if (count == 3) {
                            count = 0;
                        } else {
                            throw new BridgeException(this.ctx, (Element)this.element, "attribute.malformed", new Object[]{"keySplines", keySplinesString});
lbl30:
                            // 1 sources

                            ++count;
                        }
                        break block13;
                    }
                    end = i++;
                }
                try {
                    keySplineValue = Float.parseFloat(keySplinesString.substring(start, end));
                    keySplines.add(new Float(keySplineValue));
                }
                catch (NumberFormatException nfEx) {
                    throw new BridgeException(this.ctx, (Element)this.element, nfEx, "attribute.malformed", new Object[]{"keySplines", keySplinesString});
                }
lbl42:
                // 2 sources

                if (i < len) continue;
            }
        }
        len = keySplines.size();
        ret = new float[len];
        j = 0;
        while (j < len) {
            ret[j] = ((Float)keySplines.get(j)).floatValue();
            ++j;
        }
        return ret;
    }

    protected int getDefaultCalcMode() {
        return 1;
    }

    protected boolean canAnimateType(int type) {
        return true;
    }
}

