/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfSimpleDescript
extends GlyfDescript {
    private int[] endPtsOfContours;
    private byte[] flags;
    private short[] xCoordinates;
    private short[] yCoordinates;
    private int count;

    public GlyfSimpleDescript(GlyfTable parentTable, short numberOfContours, ByteArrayInputStream bais) {
        super(parentTable, (short)numberOfContours, bais);
        this.endPtsOfContours = new int[numberOfContours];
        int i = 0;
        while (i < numberOfContours) {
            this.endPtsOfContours[i] = bais.read() << 8 | bais.read();
            ++i;
        }
        this.count = this.endPtsOfContours[numberOfContours - 1] + 1;
        this.flags = new byte[this.count];
        this.xCoordinates = new short[this.count];
        this.yCoordinates = new short[this.count];
        int instructionCount = bais.read() << 8 | bais.read();
        this.readInstructions(bais, instructionCount);
        this.readFlags(this.count, bais);
        this.readCoords(this.count, bais);
    }

    public int getEndPtOfContours(int i) {
        return this.endPtsOfContours[i];
    }

    public byte getFlags(int i) {
        return this.flags[i];
    }

    public short getXCoordinate(int i) {
        return this.xCoordinates[i];
    }

    public short getYCoordinate(int i) {
        return this.yCoordinates[i];
    }

    public boolean isComposite() {
        return false;
    }

    public int getPointCount() {
        return this.count;
    }

    public int getContourCount() {
        return this.getNumberOfContours();
    }

    private void readCoords(int count, ByteArrayInputStream bais) {
        short x = 0;
        short y = 0;
        int i = 0;
        while (i < count) {
            if ((this.flags[i] & 0x10) != 0) {
                if ((this.flags[i] & 2) != 0) {
                    x = (short)(x + (short)bais.read());
                }
            } else {
                x = (this.flags[i] & 2) != 0 ? (short)(x + (short)(-((short)bais.read()))) : (short)(x + (short)(bais.read() << 8 | bais.read()));
            }
            this.xCoordinates[i] = x;
            ++i;
        }
        int i2 = 0;
        while (i2 < count) {
            if ((this.flags[i2] & 0x20) != 0) {
                if ((this.flags[i2] & 4) != 0) {
                    y = (short)(y + (short)bais.read());
                }
            } else {
                y = (this.flags[i2] & 4) != 0 ? (short)(y + (short)(-((short)bais.read()))) : (short)(y + (short)(bais.read() << 8 | bais.read()));
            }
            this.yCoordinates[i2] = y;
            ++i2;
        }
    }

    private void readFlags(int flagCount, ByteArrayInputStream bais) {
        try {
            int index = 0;
            while (index < flagCount) {
                this.flags[index] = (byte)bais.read();
                if ((this.flags[index] & 8) != 0) {
                    int repeats = bais.read();
                    int i = 1;
                    while (i <= repeats) {
                        this.flags[index + i] = this.flags[index];
                        ++i;
                    }
                    index += repeats;
                }
                ++index;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("error: array index out of bounds");
        }
    }
}

